/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.jclouds.deltacloud.domain.Instance;
import org.jclouds.deltacloud.domain.KeyAuthentication;
import org.jclouds.deltacloud.domain.PasswordAuthentication;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InstanceHandler
extends ParseSax.HandlerWithResult<Instance> {
    private StringBuilder currentText = new StringBuilder();
    @Resource
    protected Logger logger = Logger.NULL;
    private URI href;
    private String id;
    private String ownerId;
    private String name;
    private URI image;
    private URI hardwareProfile;
    private URI realm;
    private Instance.State state;
    private Map<Instance.Action, HttpRequest> actions = Maps.newLinkedHashMap();
    private Set<String> publicAddresses = Sets.newLinkedHashSet();
    private Set<String> privateAddresses = Sets.newLinkedHashSet();
    private boolean inPublicAddresses;
    private boolean inPrivateAddresses;
    private Instance instance;
    private LoginCredentials.Builder credentialsBuilder = LoginCredentials.builder();
    private String keyName;
    private Instance.Authentication authentication;

    @Override
    public Instance getResult() {
        return this.instance;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        block18: {
            Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
            if (qName.equals("public_addresses")) {
                this.inPublicAddresses = true;
            } else if (qName.equals("private_addresses")) {
                this.inPrivateAddresses = true;
            } else if (qName.equals("instance")) {
                String href = attributes.get("href");
                if (href != null) {
                    this.href = URI.create(href);
                }
                this.id = attributes.get("id");
            } else {
                if (qName.equals("link")) {
                    try {
                        Instance.Action action = Instance.Action.fromValue(attributes.get("rel"));
                        if (action != Instance.Action.UNRECOGNIZED) {
                            HttpRequest request = new HttpRequest(attributes.get("method").toUpperCase(), URI.create(attributes.get("href")));
                            this.actions.put(action, request);
                        }
                        break block18;
                    }
                    catch (RuntimeException e) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.warn(e, "error parsing into action: %s, %s", qName, attributes);
                        }
                        break block18;
                    }
                }
                if (attributes.containsKey("href")) {
                    URI href = URI.create(attributes.get("href"));
                    if (qName.equals("image")) {
                        this.image = href;
                    } else if (qName.equals("hardware_profile")) {
                        this.hardwareProfile = href;
                    } else if (qName.equals("realm")) {
                        this.realm = href;
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.endsWith("public_addresses")) {
            this.inPublicAddresses = false;
        } else if (qName.endsWith("private_addresses")) {
            this.inPrivateAddresses = false;
        }
        if (qName.equalsIgnoreCase("owner_id")) {
            this.ownerId = SaxUtils.currentOrNull(this.currentText);
        } else if (qName.equalsIgnoreCase("name")) {
            this.name = SaxUtils.currentOrNull(this.currentText);
        } else if (qName.equalsIgnoreCase("keyname")) {
            this.keyName = SaxUtils.currentOrNull(this.currentText);
        } else if (qName.equalsIgnoreCase("username")) {
            this.credentialsBuilder.user(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equalsIgnoreCase("password")) {
            this.credentialsBuilder.password(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equalsIgnoreCase("authentication")) {
            if (this.keyName != null) {
                this.authentication = new KeyAuthentication(this.keyName);
            } else {
                LoginCredentials creds = this.credentialsBuilder.build();
                if (creds != null && creds.identity != null) {
                    this.authentication = new PasswordAuthentication(creds);
                }
            }
            this.keyName = null;
            this.credentialsBuilder = LoginCredentials.builder();
        } else if (qName.equalsIgnoreCase("state")) {
            this.state = Instance.State.fromValue(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equalsIgnoreCase("address")) {
            if (this.inPublicAddresses) {
                this.publicAddresses.add(SaxUtils.currentOrNull(this.currentText));
            } else if (this.inPrivateAddresses) {
                this.privateAddresses.add(SaxUtils.currentOrNull(this.currentText));
            }
        } else if (qName.equalsIgnoreCase("instance")) {
            this.instance = new Instance(this.href, this.id, this.ownerId, this.name, this.image, this.hardwareProfile, this.realm, this.state, this.actions, this.authentication, this.publicAddresses, this.privateAddresses);
            this.href = null;
            this.id = null;
            this.ownerId = null;
            this.name = null;
            this.image = null;
            this.hardwareProfile = null;
            this.realm = null;
            this.state = null;
            this.authentication = null;
            this.actions = Maps.newLinkedHashMap();
            this.publicAddresses = Sets.newLinkedHashSet();
            this.privateAddresses = Sets.newLinkedHashSet();
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

