/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.xml;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import javax.annotation.Resource;
import org.jclouds.deltacloud.domain.Instance;
import org.jclouds.deltacloud.domain.Transition;
import org.jclouds.deltacloud.domain.TransitionAutomatically;
import org.jclouds.deltacloud.domain.TransitionOnAction;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InstanceStatesHandler
extends ParseSax.HandlerWithResult<Multimap<Instance.State, ? extends Transition>> {
    @Resource
    protected Logger logger = Logger.NULL;
    private Multimap<Instance.State, Transition> states = LinkedHashMultimap.create();
    private Instance.State state;

    @Override
    public Multimap<Instance.State, ? extends Transition> getResult() {
        return this.states;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (qName.equals("state")) {
            this.state = this.instanceStateWarningOnUnrecognized(attributes.get("name"));
        } else if (qName.equals("transition")) {
            if (attributes.containsKey("auto")) {
                this.states.put(this.state, new TransitionAutomatically(this.instanceStateWarningOnUnrecognized(attributes.get("to"))));
            } else {
                this.states.put(this.state, new TransitionOnAction(this.instanceActionWarningOnUnrecognized(attributes.get("action")), this.instanceStateWarningOnUnrecognized(attributes.get("to"))));
            }
        }
    }

    Instance.State instanceStateWarningOnUnrecognized(String input) {
        Instance.State state = Instance.State.fromValue(input);
        if (state == Instance.State.UNRECOGNIZED) {
            this.logger.warn("unrecognized state: %s", input);
        }
        return state;
    }

    Instance.Action instanceActionWarningOnUnrecognized(String input) {
        Instance.Action action = Instance.Action.fromValue(input);
        if (action == Instance.Action.UNRECOGNIZED) {
            this.logger.warn("unrecognized action: %s", input);
        }
        return action;
    }
}

