/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Map;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

public class BindBlockDeviceMappingToIndexedFormParams
implements Binder {
    private static final String deviceNamePattern = "BlockDeviceMapping.%d.DeviceName";
    private static final String volumeIdPattern = "BlockDeviceMapping.%d.Ebs.VolumeId";
    private static final String deleteOnTerminationPattern = "BlockDeviceMapping.%d.Ebs.DeleteOnTermination";

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Map, "this binder is only valid for Map");
        Map blockDeviceMapping = (Map)input;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int amazonOneBasedIndex = 1;
        for (Map.Entry ebsBlockDeviceName : blockDeviceMapping.entrySet()) {
            builder.put(String.format(volumeIdPattern, amazonOneBasedIndex), ((BlockDevice)ebsBlockDeviceName.getValue()).getVolumeId());
            builder.put(String.format(deviceNamePattern, amazonOneBasedIndex), ebsBlockDeviceName.getKey());
            builder.put(String.format(deleteOnTerminationPattern, amazonOneBasedIndex), String.valueOf(((BlockDevice)ebsBlockDeviceName.getValue()).isDeleteOnTermination()));
            ++amazonOneBasedIndex;
        }
        SetMultimap<String, String> forms = Multimaps.forMap(builder.build());
        return forms.size() == 0 ? request : ModifyRequest.putFormParams(request, forms);
    }
}

