/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.base.Preconditions;
import org.jclouds.ec2.domain.IpPermission;
import org.jclouds.ec2.util.IpPermissions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

public class BindIpPermissionToIndexedFormParams
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof IpPermission, "this binder is only valid for IpPermission");
        IpPermission perm = (IpPermission)input;
        return ModifyRequest.putFormParams(request, IpPermissions.buildFormParametersForIndex(0, perm));
    }
}

