/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import org.jclouds.ec2.domain.IpPermission;
import org.jclouds.ec2.util.IpPermissions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

public class BindIpPermissionsToIndexedFormParams
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Iterable, "this binder is only valid for Iterable<IpPermission>");
        ImmutableMultimap.Builder<String, String> headers = ImmutableMultimap.builder();
        int index = 0;
        for (IpPermission perm : (Iterable)input) {
            headers.putAll(IpPermissions.buildFormParametersForIndex(index++, perm));
        }
        return ModifyRequest.putFormParams(request, headers.build());
    }
}

