/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindS3UploadPolicyAndSignature
implements Binder {
    private final FormSigner signer;

    @Inject
    BindS3UploadPolicyAndSignature(FormSigner signer) {
        this.signer = signer;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        String encodedJson = CryptoStreams.base64(Preconditions.checkNotNull(input, "json").toString().getBytes(Charsets.UTF_8));
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        builder.put("Storage.S3.UploadPolicy", encodedJson);
        String signature = this.signer.sign(encodedJson);
        builder.put("Storage.S3.UploadPolicySignature", signature);
        return ModifyRequest.putFormParams(request, builder.build());
    }
}

