/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.internal.ComputeServiceContextImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Credentials;
import org.jclouds.ec2.EC2AsyncClient;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.EC2ComputeService;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.AddElasticIpsToNodemetadata;
import org.jclouds.ec2.compute.functions.CreateSecurityGroupIfNeeded;
import org.jclouds.ec2.compute.functions.CreateUniqueKeyPair;
import org.jclouds.ec2.compute.functions.CredentialsForInstance;
import org.jclouds.ec2.compute.functions.LoadPublicIpForInstanceOrNull;
import org.jclouds.ec2.compute.functions.RegionAndIdToImage;
import org.jclouds.ec2.compute.functions.RunningInstanceToNodeMetadata;
import org.jclouds.ec2.compute.internal.EC2TemplateBuilderImpl;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.compute.predicates.SecurityGroupPresent;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.predicates.RetryablePredicate;

public class EC2ComputeServiceDependenciesModule
extends AbstractModule {
    public static final Map<InstanceState, NodeState> instanceToNodeState = ImmutableMap.builder().put(InstanceState.PENDING, NodeState.PENDING).put(InstanceState.RUNNING, NodeState.RUNNING).put(InstanceState.SHUTTING_DOWN, NodeState.PENDING).put(InstanceState.TERMINATED, NodeState.TERMINATED).put(InstanceState.STOPPING, NodeState.PENDING).put(InstanceState.STOPPED, NodeState.SUSPENDED).put(InstanceState.UNRECOGNIZED, NodeState.UNRECOGNIZED).build();

    @Singleton
    @Provides
    Map<InstanceState, NodeState> provideServerToNodeState() {
        return instanceToNodeState;
    }

    @Override
    protected void configure() {
        this.bind(TemplateBuilder.class).to(EC2TemplateBuilderImpl.class);
        this.bind(TemplateOptions.class).to(EC2TemplateOptions.class);
        this.bind(ComputeService.class).to(EC2ComputeService.class);
        this.bind(new TypeLiteral<CacheLoader<RunningInstance, Credentials>>(){}).to(CredentialsForInstance.class);
        this.bind(new TypeLiteral<Function<RegionAndName, KeyPair>>(){}).to(CreateUniqueKeyPair.class);
        this.bind(new TypeLiteral<CacheLoader<RegionAndName, Image>>(){}).to(RegionAndIdToImage.class);
        this.bind(new TypeLiteral<CacheLoader<RegionAndName, String>>(){}).annotatedWith(Names.named("SECURITY")).to(CreateSecurityGroupIfNeeded.class);
        this.bind(new TypeLiteral<CacheLoader<RegionAndName, String>>(){}).annotatedWith(Names.named("ELASTICIP")).to(LoadPublicIpForInstanceOrNull.class);
        this.bind(new TypeLiteral<ComputeServiceContext>(){}).to((TypeLiteral<ComputeServiceContext>)new TypeLiteral<ComputeServiceContextImpl<EC2Client, EC2AsyncClient>>(){}).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public Function<RunningInstance, NodeMetadata> bindNodeConverter(RunningInstanceToNodeMetadata baseConverter, AddElasticIpsToNodemetadata addElasticIpsToNodemetadata, @Named(value="jclouds.ec2.auto-allocate-elastic-ips") boolean autoAllocateElasticIps) {
        if (!autoAllocateElasticIps) {
            return baseConverter;
        }
        return Functions.compose(addElasticIpsToNodemetadata, baseConverter);
    }

    @Provides
    @Singleton
    Supplier<String> provideSuffix() {
        return new Supplier<String>(){
            final SecureRandom random = new SecureRandom();

            @Override
            public String get() {
                return this.random.nextInt(100) + "";
            }
        };
    }

    @Provides
    @Singleton
    protected LoadingCache<RunningInstance, Credentials> credentialsMap(CacheLoader<RunningInstance, Credentials> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Singleton
    protected ConcurrentMap<RegionAndName, KeyPair> keypairMap(Injector i) {
        return Maps.newConcurrentMap();
    }

    @Provides
    @Singleton
    @Named(value="SECURITY")
    protected LoadingCache<RegionAndName, String> securityGroupMap(@Named(value="SECURITY") CacheLoader<RegionAndName, String> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Singleton
    @Named(value="ELASTICIP")
    protected LoadingCache<RegionAndName, String> instanceToElasticIp(@Named(value="ELASTICIP") CacheLoader<RegionAndName, String> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Singleton
    @Named(value="SECURITY")
    protected Predicate<RegionAndName> securityGroupEventualConsistencyDelay(SecurityGroupPresent in, @Named(value="jclouds.ec2.timeout.securitygroup-present") long msDelay) {
        return new RetryablePredicate<RegionAndName>(in, msDelay, 100L, TimeUnit.MILLISECONDS);
    }
}

