/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.ec2.domain.IpProtocol;
import org.jclouds.ec2.domain.UserIdGroupPair;
import org.jclouds.ec2.services.SecurityGroupClient;
import org.jclouds.logging.Logger;

@Singleton
public class CreateSecurityGroupIfNeeded
extends CacheLoader<RegionAndName, String> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final SecurityGroupClient securityClient;
    protected final Predicate<RegionAndName> securityGroupEventualConsistencyDelay;

    @Inject
    public CreateSecurityGroupIfNeeded(EC2Client ec2Client, @Named(value="SECURITY") Predicate<RegionAndName> securityGroupEventualConsistencyDelay) {
        this(Preconditions.checkNotNull(ec2Client, "ec2Client").getSecurityGroupServices(), securityGroupEventualConsistencyDelay);
    }

    public CreateSecurityGroupIfNeeded(SecurityGroupClient securityClient, @Named(value="SECURITY") Predicate<RegionAndName> securityGroupEventualConsistencyDelay) {
        this.securityClient = Preconditions.checkNotNull(securityClient, "securityClient");
        this.securityGroupEventualConsistencyDelay = Preconditions.checkNotNull(securityGroupEventualConsistencyDelay, "securityGroupEventualConsistencyDelay");
    }

    @Override
    public String load(RegionAndName from) {
        RegionNameAndIngressRules realFrom = (RegionNameAndIngressRules)RegionNameAndIngressRules.class.cast(from);
        this.createSecurityGroupInRegion(from.getRegion(), from.getName(), realFrom.getPorts());
        return from.getName();
    }

    private void createSecurityGroupInRegion(String region, String name, int ... ports) {
        Preconditions.checkNotNull(region, "region");
        Preconditions.checkNotNull(name, "name");
        this.logger.debug(">> creating securityGroup region(%s) name(%s)", region, name);
        try {
            this.securityClient.createSecurityGroupInRegion(region, name, name);
            boolean created = this.securityGroupEventualConsistencyDelay.apply(new RegionAndName(region, name));
            if (!created) {
                throw new RuntimeException(String.format("security group %s/%s is not available after creating", region, name));
            }
            this.logger.debug("<< created securityGroup(%s)", name);
            for (int port : ports) {
                this.createIngressRuleForTCPPort(region, name, port);
            }
            if (ports.length > 0) {
                this.authorizeGroupToItself(region, name);
            }
        }
        catch (IllegalStateException e) {
            this.logger.debug("<< reused securityGroup(%s)", name);
        }
    }

    private void createIngressRuleForTCPPort(String region, String name, int port) {
        this.logger.debug(">> authorizing securityGroup region(%s) name(%s) port(%s)", region, name, port);
        this.securityClient.authorizeSecurityGroupIngressInRegion(region, name, IpProtocol.TCP, port, port, "0.0.0.0/0");
        this.logger.debug("<< authorized securityGroup(%s)", name);
    }

    private void authorizeGroupToItself(String region, String name) {
        this.logger.debug(">> authorizing securityGroup region(%s) name(%s) permission to itself", region, name);
        String myOwnerId = Iterables.get(this.securityClient.describeSecurityGroupsInRegion(region, name), 0).getOwnerId();
        this.securityClient.authorizeSecurityGroupIngressInRegion(region, name, new UserIdGroupPair(myOwnerId, name));
        this.logger.debug("<< authorized securityGroup(%s)", name);
    }
}

