/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.domain.Credentials;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.domain.RunningInstance;

@Singleton
public class CredentialsForInstance
extends CacheLoader<RunningInstance, Credentials> {
    private final ConcurrentMap<RegionAndName, KeyPair> credentialsMap;
    private final Supplier<LoadingCache<RegionAndName, ? extends Image>> imageMap;

    @Inject
    CredentialsForInstance(ConcurrentMap<RegionAndName, KeyPair> credentialsMap, Supplier<LoadingCache<RegionAndName, ? extends Image>> imageMap) {
        this.credentialsMap = Preconditions.checkNotNull(credentialsMap, "credentialsMap");
        this.imageMap = imageMap;
    }

    @Override
    public Credentials load(RunningInstance instance) throws ExecutionException {
        Credentials credentials = null;
        if (instance.getKeyName() != null) {
            credentials = new Credentials(this.getLoginAccountFor(instance), this.getPrivateKeyOrNull(instance));
        }
        return credentials;
    }

    @VisibleForTesting
    String getPrivateKeyOrNull(RunningInstance instance) throws ExecutionException {
        KeyPair keyPair = (KeyPair)this.credentialsMap.get(new RegionAndName(instance.getRegion(), instance.getKeyName()));
        return keyPair != null ? keyPair.getKeyMaterial() : null;
    }

    @VisibleForTesting
    String getLoginAccountFor(RunningInstance from) throws ExecutionException {
        return this.imageMap.get().get((RegionAndName)new RegionAndName((String)from.getRegion(), (String)from.getImageId())).getDefaultCredentials().identity;
    }
}

