/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.domain.BlockDeviceMapping;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.util.Preconditions2;

public class EC2TemplateOptions
extends TemplateOptions
implements Cloneable {
    private Set<String> groupNames = ImmutableSet.of();
    private String keyPair = null;
    private boolean noKeyPair;
    private byte[] userData;
    private ImmutableSet.Builder<BlockDeviceMapping> blockDeviceMappings = ImmutableSet.builder();
    public static final EC2TemplateOptions NONE = new EC2TemplateOptions();

    @Override
    public EC2TemplateOptions clone() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        this.copyTo(options);
        return options;
    }

    @Override
    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof EC2TemplateOptions) {
            EC2TemplateOptions eTo = (EC2TemplateOptions)EC2TemplateOptions.class.cast(to);
            if (this.getGroups().size() > 0) {
                eTo.securityGroups(this.getGroups());
            }
            if (this.getKeyPair() != null) {
                eTo.keyPair(this.getKeyPair());
            }
            if (this.getBlockDeviceMappings().size() > 0) {
                eTo.blockDeviceMappings(this.getBlockDeviceMappings());
            }
            if (!this.shouldAutomaticallyCreateKeyPair()) {
                eTo.noKeyPair();
            }
            if (this.getUserData() != null) {
                eTo.userData(this.getUserData());
            }
        }
    }

    public EC2TemplateOptions securityGroups(String ... groupNames) {
        return this.securityGroups(ImmutableSet.copyOf(groupNames));
    }

    public EC2TemplateOptions securityGroups(Iterable<String> groupNames) {
        Preconditions.checkArgument(Iterables.size(groupNames) > 0, "you must specify at least one security group");
        for (String groupId : groupNames) {
            Preconditions2.checkNotEmpty(groupId, "all security groups must be non-empty");
        }
        this.groupNames = ImmutableSet.copyOf(groupNames);
        return this;
    }

    public EC2TemplateOptions userData(byte[] unencodedData) {
        Preconditions.checkArgument(Preconditions.checkNotNull(unencodedData, "unencodedData").length <= 16384, "userData cannot be larger than 16kb");
        this.userData = unencodedData;
        return this;
    }

    public EC2TemplateOptions keyPair(String keyPair) {
        Preconditions.checkNotNull(keyPair, "use noKeyPair option to request boot without a keypair");
        Preconditions.checkState(!this.noKeyPair, "you cannot specify both options keyPair and noKeyPair");
        Preconditions2.checkNotEmpty(keyPair, "keypair must be non-empty");
        this.keyPair = keyPair;
        return this;
    }

    public EC2TemplateOptions noKeyPair() {
        Preconditions.checkState(this.keyPair == null, "you cannot specify both options keyPair and noKeyPair");
        this.noKeyPair = true;
        return this;
    }

    public EC2TemplateOptions mapEBSSnapshotToDeviceName(String deviceName, String snapshotId, @Nullable Integer sizeInGib, boolean deleteOnTermination) {
        this.blockDeviceMappings.add((Object)new BlockDeviceMapping.MapEBSSnapshotToDevice(deviceName, snapshotId, sizeInGib, deleteOnTermination));
        return this;
    }

    public EC2TemplateOptions mapNewVolumeToDeviceName(String deviceName, int sizeInGib, boolean deleteOnTermination) {
        this.blockDeviceMappings.add((Object)new BlockDeviceMapping.MapNewVolumeToDevice(deviceName, sizeInGib, deleteOnTermination));
        return this;
    }

    public EC2TemplateOptions mapEphemeralDeviceToDeviceName(String deviceName, String virtualName) {
        this.blockDeviceMappings.add((Object)new BlockDeviceMapping.MapEphemeralDeviceToDevice(deviceName, virtualName));
        return this;
    }

    public EC2TemplateOptions unmapDeviceNamed(String deviceName) {
        this.blockDeviceMappings.add((Object)new BlockDeviceMapping.UnmapDeviceNamed(deviceName));
        return this;
    }

    public EC2TemplateOptions blockDeviceMappings(Iterable<? extends BlockDeviceMapping> blockDeviceMappings) {
        this.blockDeviceMappings.addAll(Preconditions.checkNotNull(blockDeviceMappings, "blockDeviceMappings"));
        return this;
    }

    @Override
    public EC2TemplateOptions blockOnPort(int port, int seconds) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    @Override
    public EC2TemplateOptions inboundPorts(int ... ports) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.inboundPorts(ports));
    }

    @Override
    public EC2TemplateOptions authorizePublicKey(String publicKey) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    @Override
    public EC2TemplateOptions installPrivateKey(String privateKey) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    @Override
    @Deprecated
    public EC2TemplateOptions runScript(Payload script) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.runScript(script));
    }

    @Override
    public EC2TemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    @Override
    public EC2TemplateOptions dontAuthorizePublicKey() {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    @Override
    public EC2TemplateOptions nameTask(String name) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.nameTask(name));
    }

    @Override
    public EC2TemplateOptions runAsRoot(boolean runAsRoot) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    @Override
    public EC2TemplateOptions runScript(Statement script) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.runScript(script));
    }

    @Override
    @Deprecated
    public EC2TemplateOptions overrideCredentialsWith(Credentials overridingCredentials) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.overrideCredentialsWith(overridingCredentials));
    }

    @Override
    @Deprecated
    public EC2TemplateOptions overrideLoginUserWith(String loginUser) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.overrideLoginUserWith(loginUser));
    }

    @Override
    @Deprecated
    public EC2TemplateOptions overrideLoginCredentialWith(String loginCredential) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.overrideLoginCredentialWith(loginCredential));
    }

    @Override
    public EC2TemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    @Override
    public EC2TemplateOptions overrideLoginPassword(String password) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    @Override
    public EC2TemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    @Override
    public EC2TemplateOptions overrideLoginUser(String loginUser) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    @Override
    public EC2TemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    @Override
    public EC2TemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    @Override
    public EC2TemplateOptions userMetadata(String key, String value) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public Set<String> getGroups() {
        return this.groupNames;
    }

    public String getKeyPair() {
        return this.keyPair;
    }

    public boolean shouldAutomaticallyCreateKeyPair() {
        return !this.noKeyPair;
    }

    public byte[] getUserData() {
        return this.userData;
    }

    public Set<BlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings.build();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.blockDeviceMappings == null ? 0 : this.blockDeviceMappings.hashCode());
        result = 31 * result + (this.groupNames == null ? 0 : ((Object)this.groupNames).hashCode());
        result = 31 * result + (this.keyPair == null ? 0 : this.keyPair.hashCode());
        result = 31 * result + (this.noKeyPair ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.userData);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EC2TemplateOptions other = (EC2TemplateOptions)obj;
        if (this.blockDeviceMappings == null ? other.blockDeviceMappings != null : !this.blockDeviceMappings.equals(other.blockDeviceMappings)) {
            return false;
        }
        if (this.groupNames == null ? other.groupNames != null : !((Object)this.groupNames).equals(other.groupNames)) {
            return false;
        }
        if (this.keyPair == null ? other.keyPair != null : !this.keyPair.equals(other.keyPair)) {
            return false;
        }
        return Arrays.equals(this.userData, other.userData);
    }

    @Override
    public String toString() {
        return "[groupNames=" + this.groupNames + ", keyPair=" + this.keyPair + ", noKeyPair=" + this.noKeyPair + ", userData=" + Arrays.toString(this.userData) + ", blockDeviceMappings=" + this.blockDeviceMappings.build() + "]";
    }

    public static class Builder {
        public static EC2TemplateOptions blockDeviceMappings(Set<? extends BlockDeviceMapping> blockDeviceMappings) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.blockDeviceMappings(blockDeviceMappings);
        }

        public static EC2TemplateOptions mapEBSSnapshotToDeviceName(String deviceName, String snapshotId, @Nullable Integer sizeInGib, boolean deleteOnTermination) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.mapEBSSnapshotToDeviceName(deviceName, snapshotId, sizeInGib, deleteOnTermination);
        }

        public static EC2TemplateOptions mapNewVolumeToDeviceName(String deviceName, int sizeInGib, boolean deleteOnTermination) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.mapNewVolumeToDeviceName(deviceName, sizeInGib, deleteOnTermination);
        }

        public static EC2TemplateOptions mapEphemeralDeviceToDeviceName(String deviceName, String virtualName) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.mapEphemeralDeviceToDeviceName(deviceName, virtualName);
        }

        public static EC2TemplateOptions unmapDeviceNamed(String deviceName) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.unmapDeviceNamed(deviceName);
        }

        public static EC2TemplateOptions securityGroups(String ... groupNames) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.securityGroups(groupNames));
        }

        public static EC2TemplateOptions securityGroups(Iterable<String> groupNames) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.securityGroups(groupNames));
        }

        public static EC2TemplateOptions keyPair(String keyPair) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.keyPair(keyPair));
        }

        public static EC2TemplateOptions userData(byte[] unencodedData) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.userData(unencodedData));
        }

        public static EC2TemplateOptions noKeyPair() {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.noKeyPair());
        }

        public static EC2TemplateOptions inboundPorts(int ... ports) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static EC2TemplateOptions blockOnPort(int port, int seconds) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static EC2TemplateOptions installPrivateKey(String rsaKey) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.installPrivateKey(rsaKey));
        }

        public static EC2TemplateOptions authorizePublicKey(String rsaKey) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.authorizePublicKey(rsaKey));
        }

        public static EC2TemplateOptions userMetadata(Map<String, String> userMetadata) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        @Deprecated
        public static EC2TemplateOptions overrideLoginUserWith(String user) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.overrideLoginUserWith(user);
        }

        public static EC2TemplateOptions overrideLoginUser(String user) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.overrideLoginUser(user);
        }

        public static EC2TemplateOptions overrideLoginPassword(String password) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.overrideLoginPassword(password);
        }

        public static EC2TemplateOptions overrideLoginPrivateKey(String privateKey) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static EC2TemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        @Deprecated
        public static EC2TemplateOptions overrideLoginCredentialWith(String credential) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.overrideLoginCredentialWith(credential);
        }

        @Deprecated
        public static EC2TemplateOptions overrideCredentialsWith(Credentials credentials) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.overrideCredentialsWith(credentials);
        }

        public static EC2TemplateOptions overrideLoginCredentials(LoginCredentials credentials) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.overrideLoginCredentials(credentials);
        }
    }
}

