/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.strategy.impl.ReturnCredentialsBoundToImage;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

@Singleton
public class EC2PopulateDefaultLoginCredentialsForImageStrategy
extends ReturnCredentialsBoundToImage {
    public EC2PopulateDefaultLoginCredentialsForImageStrategy() {
        this(null, ImmutableMap.of());
    }

    @Inject
    public EC2PopulateDefaultLoginCredentialsForImageStrategy(@Nullable @Named(value="image") LoginCredentials creds, Map<String, Credentials> credentialStore) {
        super(creds, credentialStore);
    }

    @Override
    public LoginCredentials apply(Object resourceToAuthenticate) {
        if (this.creds != null) {
            return this.creds;
        }
        LoginCredentials.Builder credentials = LoginCredentials.builder().user("root");
        if (resourceToAuthenticate != null) {
            String owner = null;
            if (resourceToAuthenticate instanceof org.jclouds.ec2.domain.Image) {
                owner = ((org.jclouds.ec2.domain.Image)org.jclouds.ec2.domain.Image.class.cast(resourceToAuthenticate)).getImageOwnerId();
            } else if (resourceToAuthenticate instanceof Image) {
                owner = ((Image)Image.class.cast(resourceToAuthenticate)).getUserMetadata().get("owner");
            }
            Preconditions.checkArgument(owner != null, "Resource must be an image (for EC2)");
            if (owner.matches("063491364108|099720109477")) {
                credentials.user("ubuntu");
            } else if (owner.equals("137112412989")) {
                credentials.user("ec2-user");
            }
        }
        return credentials.build();
    }
}

