/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.services.InstanceClient;

@Singleton
public class EC2SuspendNodeStrategy
implements SuspendNodeStrategy {
    private final InstanceClient client;
    private final GetNodeMetadataStrategy getNode;

    @Inject
    protected EC2SuspendNodeStrategy(EC2Client client, GetNodeMetadataStrategy getNode) {
        this.client = client.getInstanceServices();
        this.getNode = getNode;
    }

    @Override
    public NodeMetadata suspendNode(String id) {
        String[] parts = AWSUtils.parseHandle(id);
        String region = parts[0];
        String instanceId = parts[1];
        this.client.stopInstancesInRegion(region, true, instanceId);
        return this.getNode.getNode(id);
    }
}

