/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.ec2.domain.IpPermission;
import org.jclouds.ec2.domain.IpProtocol;

public class IpPermissionImpl
implements IpPermission {
    private final int fromPort;
    private final int toPort;
    private final Multimap<String, String> userIdGroupPairs;
    private final Set<String> groupIds;
    private final IpProtocol ipProtocol;
    private final Set<String> ipRanges;

    public static Builder builder() {
        return new Builder();
    }

    public IpPermissionImpl(IpProtocol ipProtocol, int fromPort, int toPort, Multimap<String, String> userIdGroupPairs, Iterable<String> groupIds, Iterable<String> ipRanges) {
        this.fromPort = fromPort;
        this.toPort = toPort;
        this.userIdGroupPairs = ImmutableMultimap.copyOf(Preconditions.checkNotNull(userIdGroupPairs, "userIdGroupPairs"));
        this.ipProtocol = Preconditions.checkNotNull(ipProtocol, "ipProtocol");
        this.groupIds = ImmutableSet.copyOf(Preconditions.checkNotNull(groupIds, "groupIds"));
        this.ipRanges = ImmutableSet.copyOf(Preconditions.checkNotNull(ipRanges, "ipRanges"));
    }

    @Override
    public int compareTo(IpPermission o) {
        return this == o ? 0 : this.getIpProtocol().compareTo(o.getIpProtocol());
    }

    @Override
    public int getFromPort() {
        return this.fromPort;
    }

    @Override
    public int getToPort() {
        return this.toPort;
    }

    @Override
    public Multimap<String, String> getUserIdGroupPairs() {
        return this.userIdGroupPairs;
    }

    @Override
    public Set<String> getGroupIds() {
        return this.groupIds;
    }

    @Override
    public IpProtocol getIpProtocol() {
        return this.ipProtocol;
    }

    @Override
    public Set<String> getIpRanges() {
        return this.ipRanges;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fromPort;
        result = 31 * result + (this.groupIds == null ? 0 : ((Object)this.groupIds).hashCode());
        result = 31 * result + (this.ipProtocol == null ? 0 : this.ipProtocol.hashCode());
        result = 31 * result + (this.ipRanges == null ? 0 : ((Object)this.ipRanges).hashCode());
        result = 31 * result + this.toPort;
        result = 31 * result + (this.userIdGroupPairs == null ? 0 : ((Object)this.userIdGroupPairs).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IpPermissionImpl other = (IpPermissionImpl)obj;
        if (this.fromPort != other.fromPort) {
            return false;
        }
        if (this.groupIds == null ? other.groupIds != null : !((Object)this.groupIds).equals(other.groupIds)) {
            return false;
        }
        if (this.ipProtocol != other.ipProtocol) {
            return false;
        }
        if (this.ipRanges == null ? other.ipRanges != null : !((Object)this.ipRanges).equals(other.ipRanges)) {
            return false;
        }
        if (this.toPort != other.toPort) {
            return false;
        }
        return !(this.userIdGroupPairs == null ? other.userIdGroupPairs != null : !((Object)this.userIdGroupPairs).equals(other.userIdGroupPairs));
    }

    public String toString() {
        return "[fromPort=" + this.fromPort + ", toPort=" + this.toPort + ", userIdGroupPairs=" + this.userIdGroupPairs + ", groupIds=" + this.groupIds + ", ipProtocol=" + (Object)((Object)this.ipProtocol) + ", ipRanges=" + this.ipRanges + "]";
    }

    public static class Builder {
        private int fromPort;
        private int toPort;
        private IpProtocol ipProtocol;
        private Multimap<String, String> userIdGroupPairs = LinkedHashMultimap.create();
        private Set<String> groupIds = Sets.newLinkedHashSet();
        private Set<String> ipRanges = Sets.newLinkedHashSet();

        public Builder fromPort(int fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public Builder toPort(int toPort) {
            this.fromPort = toPort;
            return this;
        }

        public Builder ipProtocol(IpProtocol ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public Builder userIdGroupPair(String userId, String groupNameOrId) {
            this.userIdGroupPairs.put(userId, groupNameOrId);
            return this;
        }

        public Builder userIdGroupPairs(Multimap<String, String> userIdGroupPairs) {
            this.userIdGroupPairs.putAll(userIdGroupPairs);
            return this;
        }

        public Builder ipRange(String ipRange) {
            this.ipRanges.add(ipRange);
            return this;
        }

        public Builder ipRanges(Iterable<String> ipRanges) {
            Iterables.addAll(this.ipRanges, ipRanges);
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupIds.add(groupId);
            return this;
        }

        public Builder groupIds(Iterable<String> groupIds) {
            Iterables.addAll(this.groupIds, groupIds);
            return this;
        }

        public IpPermission build() {
            return new IpPermissionImpl(this.ipProtocol, this.fromPort, this.toPort, this.userIdGroupPairs, this.groupIds, this.ipRanges);
        }
    }
}

