/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.base.Preconditions;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.options.RegisterImageOptions;
import org.jclouds.javax.annotation.Nullable;

public class RegisterImageBackedByEbsOptions
extends RegisterImageOptions {
    private int deviceIndex = 1;

    public RegisterImageBackedByEbsOptions addEphemeralBlockDeviceFromSnapshot(String deviceName, @Nullable String virtualName, String snapshotId) {
        this.formParameters.put("BlockDeviceMapping." + this.deviceIndex + ".DeviceName", Preconditions.checkNotNull(deviceName, "deviceName"));
        if (virtualName != null) {
            this.formParameters.put("BlockDeviceMapping." + this.deviceIndex + ".VirtualName", Preconditions.checkNotNull(virtualName, "virtualName"));
        }
        this.formParameters.put("BlockDeviceMapping." + this.deviceIndex + ".Ebs.SnapshotId", Preconditions.checkNotNull(snapshotId, "snapshotId"));
        ++this.deviceIndex;
        return this;
    }

    public RegisterImageBackedByEbsOptions addNewEphemeralBlockDevice(String deviceName, @Nullable String virtualName, int volumeSize) {
        Preconditions.checkArgument(volumeSize > 0 && volumeSize < 1025, "volumeSize must be between 1 and 1024 gb");
        this.formParameters.put("BlockDeviceMapping." + this.deviceIndex + ".DeviceName", Preconditions.checkNotNull(deviceName, "deviceName"));
        if (virtualName != null) {
            this.formParameters.put("BlockDeviceMapping." + this.deviceIndex + ".VirtualName", Preconditions.checkNotNull(virtualName, "virtualName"));
        }
        this.formParameters.put("BlockDeviceMapping." + this.deviceIndex + ".Ebs.VolumeSize", volumeSize + "");
        ++this.deviceIndex;
        return this;
    }

    public RegisterImageBackedByEbsOptions addBlockDeviceFromSnapshot(String deviceName, @Nullable String virtualName, String snapshotId) {
        this.formParameters.put("BlockDeviceMapping." + this.deviceIndex + ".Ebs.DeleteOnTermination", "false");
        this.addEphemeralBlockDeviceFromSnapshot(deviceName, virtualName, snapshotId);
        return this;
    }

    public RegisterImageBackedByEbsOptions addNewBlockDevice(String deviceName, @Nullable String virtualName, int volumeSize) {
        this.formParameters.put("BlockDeviceMapping." + this.deviceIndex + ".Ebs.DeleteOnTermination", "false");
        this.addNewEphemeralBlockDevice(deviceName, virtualName, volumeSize);
        return this;
    }

    @Override
    public RegisterImageBackedByEbsOptions asArchitecture(Image.Architecture architecture) {
        return (RegisterImageBackedByEbsOptions)super.asArchitecture(architecture);
    }

    @Override
    public RegisterImageBackedByEbsOptions withDescription(String info) {
        return (RegisterImageBackedByEbsOptions)super.withDescription(info);
    }

    @Override
    public RegisterImageBackedByEbsOptions withKernelId(String kernelId) {
        return (RegisterImageBackedByEbsOptions)super.withKernelId(kernelId);
    }

    @Override
    public RegisterImageBackedByEbsOptions withRamdisk(String ramDiskId) {
        return (RegisterImageBackedByEbsOptions)super.withRamdisk(ramDiskId);
    }

    public static class Builder {
        public static RegisterImageBackedByEbsOptions asArchitecture(Image.Architecture architecture) {
            RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
            return options.asArchitecture(architecture);
        }

        public static RegisterImageBackedByEbsOptions withDescription(String additionalInfo) {
            RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
            return options.withDescription(additionalInfo);
        }

        public static RegisterImageBackedByEbsOptions withKernelId(String kernelId) {
            RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
            return options.withKernelId(kernelId);
        }

        public static RegisterImageBackedByEbsOptions withRamdisk(String ramdiskId) {
            RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
            return options.withRamdisk(ramdiskId);
        }

        public static RegisterImageBackedByEbsOptions addBlockDeviceFromSnapshot(String deviceName, @Nullable String virtualName, String snapshotId) {
            RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
            return options.addBlockDeviceFromSnapshot(deviceName, virtualName, snapshotId);
        }

        public static RegisterImageBackedByEbsOptions addEphemeralBlockDeviceFromSnapshot(String deviceName, @Nullable String virtualName, String snapshotId) {
            RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
            return options.addEphemeralBlockDeviceFromSnapshot(deviceName, virtualName, snapshotId);
        }

        public static RegisterImageBackedByEbsOptions addNewBlockDevice(String deviceName, @Nullable String virtualName, int volumeSize) {
            RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
            return options.addNewBlockDevice(deviceName, virtualName, volumeSize);
        }

        public static RegisterImageBackedByEbsOptions addNewEphemeralBlockDevice(String deviceName, @Nullable String virtualName, int volumeSize) {
            RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
            return options.addNewEphemeralBlockDevice(deviceName, virtualName, volumeSize);
        }
    }
}

