/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class BaseEC2RequestOptions
extends BaseHttpRequestOptions {
    @Override
    public String toString() {
        return "[formParameters=" + this.formParameters + "]";
    }

    protected void indexFormValuesWithPrefix(String prefix, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            this.formParameters.put(prefix + "." + (i + 1), Preconditions.checkNotNull(values[i], prefix.toLowerCase() + "s[" + i + "]"));
        }
    }

    protected void indexFormValuesWithPrefix(String prefix, Iterable<String> values) {
        this.indexFormValuesWithPrefix(prefix, Iterables.toArray(values, String.class));
    }

    protected Set<String> getFormValuesWithKeysPrefixedBy(final String prefix) {
        ImmutableSet.Builder values = ImmutableSet.builder();
        for (String key : Iterables.filter(this.formParameters.keySet(), new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return input.startsWith(prefix);
            }
        })) {
            values.add(Iterables.get(this.formParameters.get(key), 0));
        }
        return values.build();
    }
}

