/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.Sets;
import com.google.inject.Provider;
import java.util.Date;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public abstract class BaseReservationHandler<T>
extends ParseSax.HandlerForGeneratedRequestWithResult<T> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final DateService dateService;
    protected final String defaultRegion;
    protected final Provider<RunningInstance.Builder> builderProvider;
    protected StringBuilder currentText = new StringBuilder();
    protected RunningInstance.Builder builder;
    protected int itemDepth;
    boolean inInstancesSet;
    private String volumeId;
    private Attachment.Status attachmentStatus;
    private Date attachTime;
    private boolean deleteOnTermination;
    private String deviceName;
    private Set<String> groupIds = Sets.newLinkedHashSet();
    private String ownerId;
    private String requesterId;
    private String reservationId;
    private Set<RunningInstance> instances = Sets.newLinkedHashSet();

    @Inject
    public BaseReservationHandler(DateService dateService, @Region String defaultRegion, Provider<RunningInstance.Builder> builderProvider) {
        this.dateService = dateService;
        this.defaultRegion = defaultRegion;
        this.builderProvider = builderProvider;
        this.builder = builderProvider.get();
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (SaxUtils.equalsOrSuffix(qName, "item")) {
            ++this.itemDepth;
        } else if (SaxUtils.equalsOrSuffix(qName, "instancesSet")) {
            this.inInstancesSet = true;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "item")) {
            this.inItem();
            --this.itemDepth;
        } else if (SaxUtils.equalsOrSuffix(qName, "instancesSet")) {
            this.inInstancesSet = false;
        } else if (SaxUtils.equalsOrSuffix(qName, "groupId")) {
            this.groupIds.add(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "ownerId")) {
            this.ownerId = SaxUtils.currentOrNull(this.currentText);
        } else if (SaxUtils.equalsOrSuffix(qName, "requesterId")) {
            this.requesterId = SaxUtils.currentOrNull(this.currentText);
        } else if (SaxUtils.equalsOrSuffix(qName, "reservationId")) {
            this.reservationId = SaxUtils.currentOrNull(this.currentText);
        } else if (SaxUtils.equalsOrSuffix(qName, "amiLaunchIndex")) {
            this.builder.amiLaunchIndex(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "dnsName")) {
            String dnsName = SaxUtils.currentOrNull(this.currentText);
            if (!"0.0.0.0".equals(dnsName)) {
                this.builder.dnsName(dnsName);
            }
        } else if (SaxUtils.equalsOrSuffix(qName, "imageId")) {
            this.builder.imageId(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "instanceId")) {
            this.builder.instanceId(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "name")) {
            this.builder.instanceState(InstanceState.fromValue(SaxUtils.currentOrNull(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "instanceType")) {
            this.builder.instanceType(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "ipAddress")) {
            this.builder.ipAddress(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "kernelId")) {
            this.builder.kernelId(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "keyName")) {
            this.builder.keyName(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "launchTime")) {
            this.builder.launchTime(this.parseDate());
        } else if (SaxUtils.equalsOrSuffix(qName, "availabilityZone")) {
            this.builder.availabilityZone(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "virtualizationType")) {
            this.builder.virtualizationType(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "platform")) {
            this.builder.platform(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "privateDnsName")) {
            String privateDnsName = SaxUtils.currentOrNull(this.currentText);
            if (!"0.0.0.0".equals(privateDnsName)) {
                this.builder.privateDnsName(privateDnsName);
            }
        } else if (SaxUtils.equalsOrSuffix(qName, "privateIpAddress")) {
            this.builder.privateIpAddress(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "ramdiskId")) {
            this.builder.ramdiskId(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "reason")) {
            this.builder.reason(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "rootDeviceType")) {
            this.builder.rootDeviceType(RootDeviceType.fromValue(SaxUtils.currentOrNull(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "rootDeviceName")) {
            this.builder.rootDeviceName(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "deviceName")) {
            this.deviceName = SaxUtils.currentOrNull(this.currentText);
        } else if (SaxUtils.equalsOrSuffix(qName, "volumeId")) {
            this.volumeId = SaxUtils.currentOrNull(this.currentText);
        } else if (SaxUtils.equalsOrSuffix(qName, "status")) {
            this.attachmentStatus = Attachment.Status.fromValue(this.currentText.toString().trim());
        } else if (SaxUtils.equalsOrSuffix(qName, "attachTime")) {
            this.attachTime = this.dateService.iso8601DateParse(this.currentText.toString().trim());
        } else if (SaxUtils.equalsOrSuffix(qName, "deleteOnTermination")) {
            this.deleteOnTermination = Boolean.parseBoolean(this.currentText.toString().trim());
        } else if (SaxUtils.equalsOrSuffix(qName, "ebs")) {
            this.builder.device(this.deviceName, new BlockDevice(this.volumeId, this.attachmentStatus, this.attachTime, this.deleteOnTermination));
            this.deviceName = null;
            this.volumeId = null;
            this.attachmentStatus = null;
            this.attachTime = null;
            this.deleteOnTermination = true;
        }
        this.currentText = new StringBuilder();
    }

    protected Date parseDate() {
        try {
            return this.dateService.iso8601DateParse(SaxUtils.currentOrNull(this.currentText));
        }
        catch (RuntimeException e) {
            return this.dateService.iso8601SecondsDateParse(SaxUtils.currentOrNull(this.currentText));
        }
    }

    protected void inItem() {
        if (this.endOfInstanceItem()) {
            this.refineBuilderBeforeAddingInstance();
            this.instances.add(this.builder.build());
            this.builder = this.builderProvider.get();
        }
    }

    protected void refineBuilderBeforeAddingInstance() {
        String region;
        String string = region = this.getRequest() != null ? AWSUtils.findRegionInArgsOrNull(this.getRequest()) : null;
        if (this.builder.getIpAddress() == null && this.builder.getDnsName() != null && this.builder.getDnsName().matches(".*[0-9]$")) {
            this.builder.ipAddress(this.builder.getDnsName());
            this.builder.dnsName(null);
        }
        if (this.builder.getPrivateIpAddress() == null && this.builder.getPrivateDnsName() != null && this.builder.getPrivateDnsName().matches(".*[0-9]$")) {
            this.builder.privateIpAddress(this.builder.getPrivateDnsName());
            this.builder.privateDnsName(null);
        }
        this.builder.region(region == null ? this.defaultRegion : region);
        this.builder.groupIds(this.groupIds);
    }

    protected RunningInstance.Builder builder() {
        return this.builder;
    }

    protected boolean endOfInstanceItem() {
        return this.itemDepth <= 2 && this.inInstancesSet;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected Reservation<? extends RunningInstance> newReservation() {
        String region;
        String string = region = this.getRequest() != null ? AWSUtils.findRegionInArgsOrNull(this.getRequest()) : null;
        if (region == null) {
            region = this.defaultRegion;
        }
        Reservation<RunningInstance> info = new Reservation<RunningInstance>(region, this.groupIds, this.instances, this.ownerId, this.requesterId, this.reservationId);
        this.groupIds = Sets.newLinkedHashSet();
        this.instances = Sets.newLinkedHashSet();
        this.ownerId = null;
        this.requesterId = null;
        this.reservationId = null;
        return info;
    }
}

