/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.location.Zone;
import org.jclouds.logging.Logger;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.xml.sax.Attributes;

public class CreateVolumeResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Volume> {
    private StringBuilder currentText = new StringBuilder();
    @Resource
    protected Logger logger = Logger.NULL;
    @Inject
    protected DateService dateService;
    @Inject
    @Region
    String defaultRegion;
    @Inject
    @Zone
    protected Map<String, String> availabilityZoneToRegion;
    private String id;
    private int size;
    private String snapshotId;
    private String availabilityZone;
    private Volume.Status volumeStatus;
    private Date createTime;
    private Set<Attachment> attachments = Sets.newLinkedHashSet();
    private String volumeId;
    private String instanceId;
    private String device;
    private Attachment.Status attachmentStatus;
    private Date attachTime;
    private boolean inAttachmentSet;
    private String region;

    @Override
    public Volume getResult() {
        return this.newVolume();
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (qName.equals("attachmentSet")) {
            this.inAttachmentSet = true;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("volumeId")) {
            if (this.inAttachmentSet) {
                this.volumeId = this.currentText.toString().trim();
            } else {
                this.id = this.currentText.toString().trim();
            }
        } else if (qName.equals("size")) {
            this.size = Integer.parseInt(this.currentText.toString().trim());
        } else if (qName.equals("availabilityZone")) {
            this.availabilityZone = this.currentText.toString().trim();
        } else if (qName.equals("volumeId")) {
            if (this.inAttachmentSet) {
                this.volumeId = this.currentText.toString().trim();
            } else {
                this.id = this.currentText.toString().trim();
            }
        } else if (qName.equals("status")) {
            if (this.inAttachmentSet) {
                this.attachmentStatus = Attachment.Status.fromValue(this.currentText.toString().trim());
            } else {
                this.volumeStatus = Volume.Status.fromValue(this.currentText.toString().trim());
            }
        } else if (qName.equals("createTime")) {
            this.createTime = this.dateService.iso8601DateParse(this.currentText.toString().trim());
        } else if (qName.equals("attachmentSet")) {
            this.inAttachmentSet = false;
        } else if (qName.equals("instanceId")) {
            this.instanceId = this.currentText.toString().trim();
        } else if (qName.equals("snapshotId")) {
            this.snapshotId = this.currentText.toString().trim();
            if (this.snapshotId.equals("")) {
                this.snapshotId = null;
            }
        } else if (qName.equals("device")) {
            this.device = this.currentText.toString().trim();
        } else if (qName.equals("attachTime")) {
            this.attachTime = this.dateService.iso8601DateParse(this.currentText.toString().trim());
        } else if (qName.equals("item") && this.inAttachmentSet) {
            this.attachments.add(new Attachment(this.region, this.volumeId, this.instanceId, this.device, this.attachmentStatus, this.attachTime));
            this.volumeId = null;
            this.instanceId = null;
            this.device = null;
            this.attachmentStatus = null;
            this.attachTime = null;
        }
        this.currentText = new StringBuilder();
    }

    private Volume newVolume() {
        Volume volume = new Volume(this.region, this.id, this.size, this.snapshotId, this.availabilityZone, this.volumeStatus, this.createTime, this.attachments);
        this.id = null;
        this.size = 0;
        this.snapshotId = null;
        this.availabilityZone = null;
        this.volumeStatus = null;
        this.createTime = null;
        this.attachments = Sets.newLinkedHashSet();
        return volume;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    @Override
    public CreateVolumeResponseHandler setContext(HttpRequest request) {
        super.setContext(request);
        this.region = AWSUtils.findRegionInArgsOrNull(this.getRequest());
        if (this.region == null) {
            String zone = CreateVolumeResponseHandler.findAvailabilityZoneInArgsOrNull(this.getRequest(), this.availabilityZoneToRegion.keySet());
            this.region = zone != null ? Preconditions.checkNotNull(this.availabilityZoneToRegion.get(zone), String.format("zone %s not in %s", zone, this.availabilityZoneToRegion)) : this.defaultRegion;
        }
        return this;
    }

    public static String findAvailabilityZoneInArgsOrNull(GeneratedHttpRequest<?> gRequest, Set<String> zones) {
        for (Object arg : gRequest.getArgs()) {
            String zone;
            if (!(arg instanceof String) || !zones.contains(zone = (String)arg)) continue;
            return zone;
        }
        return null;
    }
}

