/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.util.SaxUtils;

public class DescribeKeyPairsResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Set<KeyPair>> {
    private final String defaultRegion;
    private KeyPair.Builder builder;
    private StringBuilder currentText = new StringBuilder();
    private Set<KeyPair> keyPairs = Sets.newLinkedHashSet();

    @Inject
    public DescribeKeyPairsResponseHandler(@Region String defaultRegion) {
        this.defaultRegion = defaultRegion;
        this.builder = KeyPair.builder().region(defaultRegion);
    }

    @Override
    public Set<KeyPair> getResult() {
        return this.keyPairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("keyFingerprint")) {
            this.builder.sha1OfPrivateKey(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("item")) {
            String region = AWSUtils.findRegionInArgsOrNull(this.getRequest());
            if (region != null) {
                this.builder.region(region);
            }
            try {
                this.keyPairs.add(this.builder.build());
            }
            finally {
                this.builder = KeyPair.builder().region(this.defaultRegion);
            }
        } else if (qName.equals("keyName")) {
            this.builder.keyName(SaxUtils.currentOrNull(this.currentText));
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

