/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import javax.inject.Inject;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.util.SaxUtils;

public class KeyPairResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<KeyPair> {
    private final String defaultRegion;
    private KeyPair.Builder builder;
    private StringBuilder currentText = new StringBuilder();

    @Inject
    public KeyPairResponseHandler(@Region String defaultRegion) {
        this.defaultRegion = defaultRegion;
        this.builder = KeyPair.builder().region(defaultRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyPair getResult() {
        String region = AWSUtils.findRegionInArgsOrNull(this.getRequest());
        if (region != null) {
            this.builder.region(region);
        }
        try {
            KeyPair keyPair = this.builder.build();
            return keyPair;
        }
        finally {
            this.builder = KeyPair.builder().region(this.defaultRegion);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("keyFingerprint")) {
            this.builder.sha1OfPrivateKey(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("keyMaterial")) {
            this.builder.keyMaterial(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("keyName")) {
            this.builder.keyName(SaxUtils.currentOrNull(this.currentText));
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

