/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.compute;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.elasticstack.ElasticStackClient;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.Drive;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.domain.ImageConversionType;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.domain.ServerInfo;
import org.jclouds.elasticstack.domain.ServerStatus;
import org.jclouds.elasticstack.domain.WellKnownImage;
import org.jclouds.elasticstack.util.Servers;
import org.jclouds.location.suppliers.JustProvider;
import org.jclouds.logging.Logger;

@Singleton
public class ElasticStackComputeServiceAdapter
implements ComputeServiceAdapter<ServerInfo, Hardware, DriveInfo, Location> {
    private final ElasticStackClient client;
    private final Predicate<DriveInfo> driveNotClaimed;
    private final Map<String, WellKnownImage> preinstalledImages;
    private final LoadingCache<String, DriveInfo> cache;
    private final JustProvider locationSupplier;
    private final String defaultVncPassword;
    private final ExecutorService executor;
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    @Inject
    public ElasticStackComputeServiceAdapter(ElasticStackClient client, Predicate<DriveInfo> driveNotClaimed, JustProvider locationSupplier, Map<String, WellKnownImage> preinstalledImages, LoadingCache<String, DriveInfo> cache, @Named(value="jclouds.elasticstack.vnc-password") String defaultVncPassword, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.driveNotClaimed = Preconditions.checkNotNull(driveNotClaimed, "driveNotClaimed");
        this.locationSupplier = Preconditions.checkNotNull(locationSupplier, "locationSupplier");
        this.preinstalledImages = Preconditions.checkNotNull(preinstalledImages, "preinstalledImages");
        this.cache = Preconditions.checkNotNull(cache, "cache");
        this.defaultVncPassword = Preconditions.checkNotNull(defaultVncPassword, "defaultVncPassword");
        this.executor = Preconditions.checkNotNull(executor, "executor");
    }

    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<ServerInfo> createNodeWithGroupEncodedIntoName(String tag, String name, Template template) {
        long bootSize = (long)(template.getHardware().getVolumes().get(0).getSize().floatValue() * 1024.0f * 1024.0f * 1024.0f);
        this.logger.debug(">> creating boot drive bytes(%d)", bootSize);
        DriveInfo drive = this.client.createDrive(new Drive.Builder().name(template.getImage().getId()).size(bootSize).build());
        this.logger.debug("<< drive(%s)", drive.getUuid());
        this.logger.debug(">> imaging boot drive source(%s)", template.getImage().getId());
        this.client.imageDrive(template.getImage().getId(), drive.getUuid(), ImageConversionType.GUNZIP);
        boolean success = this.driveNotClaimed.apply(drive);
        this.logger.debug("<< imaged (%s)", success);
        if (!success) {
            this.client.destroyDrive(drive.getUuid());
            throw new IllegalStateException("could not image drive in time!");
        }
        Server toCreate = Servers.small(name, drive.getUuid(), this.defaultVncPassword).mem(template.getHardware().getRam()).cpu((int)template.getHardware().getProcessors().get(0).getSpeed()).build();
        ServerInfo from = this.client.createServer(toCreate);
        this.client.startServer(from.getUuid());
        from = this.client.getServerInfo(from.getUuid());
        return new ComputeServiceAdapter.NodeAndInitialCredentials<ServerInfo>(from, from.getUuid(), LoginCredentials.builder().password(this.defaultVncPassword).build());
    }

    @Override
    public Iterable<Hardware> listHardwareProfiles() {
        ImmutableSet.Builder hardware = ImmutableSet.builder();
        for (double cpu : new double[]{1000.0, 5000.0, 10000.0, 20000.0}) {
            for (int ram : new int[]{512, 1024, 2048, 4096, 8192}) {
                final float size = (float)cpu / 1000.0f;
                String id = String.format("cpu=%f,ram=%s,disk=%f", cpu, ram, Float.valueOf(size));
                hardware.add(new HardwareBuilder().supportsImage(new Predicate<Image>(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public boolean apply(Image input) {
                        String toParse = input.getUserMetadata().get("size");
                        if (toParse == null) return false;
                        Float f = new Float(toParse);
                        if (!(f.floatValue() <= size)) return false;
                        return true;
                    }

                    public String toString() {
                        return "sizeLessThanOrEqual(" + size + ")";
                    }
                }).ids(id).ram(ram).processors(ImmutableList.of(new Processor(1.0, cpu))).volumes(ImmutableList.of(new VolumeImpl(Float.valueOf(size), true, true))).build());
            }
        }
        return hardware.build();
    }

    @Override
    public Iterable<DriveInfo> listImages() {
        Iterable<DriveInfo> drives = FutureIterables.transformParallel(this.preinstalledImages.keySet(), new Function<String, Future<DriveInfo>>(){

            @Override
            public Future<DriveInfo> apply(String input) {
                try {
                    return Futures.immediateFuture(ElasticStackComputeServiceAdapter.this.cache.getUnchecked(input));
                }
                catch (CacheLoader.InvalidCacheLoadException e) {
                    ElasticStackComputeServiceAdapter.this.logger.debug("drive %s not found", input);
                }
                catch (UncheckedExecutionException e) {
                    ElasticStackComputeServiceAdapter.this.logger.warn(e, "error finding drive %s: %s", input, e.getMessage());
                }
                return Futures.immediateFuture(null);
            }

            public String toString() {
                return "seedDriveCache()";
            }
        }, this.executor, null, this.logger, "drives");
        return Iterables.filter(drives, Predicates.notNull());
    }

    @Override
    public Iterable<ServerInfo> listNodes() {
        return this.client.listServerInfo();
    }

    @Override
    public Iterable<Location> listLocations() {
        return this.locationSupplier.get();
    }

    @Override
    public ServerInfo getNode(String id) {
        return this.client.getServerInfo(id);
    }

    @Override
    public void destroyNode(String id) {
        ServerInfo server = this.getNode(id);
        if (server != null) {
            if (server.getStatus() != ServerStatus.STOPPED) {
                this.client.stopServer(id);
            }
            this.client.destroyServer(id);
            for (Device dev : server.getDevices().values()) {
                this.client.destroyDrive(dev.getDriveUuid());
            }
        }
    }

    @Override
    public void rebootNode(String id) {
        this.client.resetServer(id);
    }

    @Override
    public void resumeNode(String id) {
        this.client.startServer(id);
    }

    @Override
    public void suspendNode(String id) {
        this.client.stopServer(id);
    }
}

