/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.FindResourceInSet;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.domain.ServerInfo;
import org.jclouds.elasticstack.domain.ServerStatus;
import org.jclouds.logging.Logger;

@Singleton
public class ServerInfoToNodeMetadata
implements Function<ServerInfo, NodeMetadata> {
    public static final Map<ServerStatus, NodeState> serverStatusToNodeState = ImmutableMap.builder().put(ServerStatus.ACTIVE, NodeState.RUNNING).put(ServerStatus.STOPPED, NodeState.SUSPENDED).put(ServerStatus.PAUSED, NodeState.SUSPENDED).put(ServerStatus.DUMPED, NodeState.PENDING).put(ServerStatus.DEAD, NodeState.TERMINATED).put(ServerStatus.UNRECOGNIZED, NodeState.UNRECOGNIZED).build();
    private final Function<Server, String> getImageIdFromServer;
    private final Function<String, Image> findImageForId;
    private final Supplier<Location> locationSupplier;
    private final Function<Device, Volume> deviceToVolume;

    @Inject
    ServerInfoToNodeMetadata(Function<Server, String> getImageIdFromServer, Function<String, Image> findImageForId, Function<Device, Volume> deviceToVolume, Supplier<Location> locationSupplier) {
        this.locationSupplier = Preconditions.checkNotNull(locationSupplier, "locationSupplier");
        this.deviceToVolume = Preconditions.checkNotNull(deviceToVolume, "deviceToVolume");
        this.findImageForId = Preconditions.checkNotNull(findImageForId, "findImageForId");
        this.getImageIdFromServer = Preconditions.checkNotNull(getImageIdFromServer, "getImageIdFromServer");
    }

    @Override
    public NodeMetadata apply(ServerInfo from) {
        Image image;
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getUuid());
        builder.name(from.getName());
        builder.location(this.locationSupplier.get());
        builder.group(ComputeServiceUtils.parseGroupFromName(from.getName()));
        String imageId = this.getImageIdFromServer.apply(from);
        if (imageId != null && (image = this.findImageForId.apply(imageId)) != null) {
            builder.operatingSystem(image.getOperatingSystem());
        }
        builder.hardware(new HardwareBuilder().ids(from.getUuid()).processors(ImmutableList.of(new Processor(1.0, from.getCpu()))).ram(from.getMem()).volumes(ImmutableList.of(Iterables.transform(from.getDevices().values(), this.deviceToVolume))).build());
        builder.state(serverStatusToNodeState.get((Object)from.getStatus()));
        builder.publicAddresses(ImmutableSet.of(from.getNics().get(0).getDhcp()));
        builder.privateAddresses(ImmutableSet.<String>of());
        return builder.build();
    }

    @Singleton
    public static class FindImageForId
    extends FindResourceInSet<String, Image> {
        @Inject
        public FindImageForId(@Memoized Supplier<Set<? extends Image>> images) {
            super(images);
        }

        @Override
        public boolean matches(String from, Image input) {
            return input.getProviderId().equals(from);
        }
    }

    @Singleton
    public static class GetImageIdFromServer
    implements Function<Server, String> {
        @Resource
        protected Logger logger = Logger.NULL;
        private final LoadingCache<String, DriveInfo> cache;

        @Inject
        public GetImageIdFromServer(LoadingCache<String, DriveInfo> cache) {
            this.cache = cache;
        }

        @Override
        public String apply(Server from) {
            String imageId = null;
            String bootDeviceId = Iterables.get(from.getBootDeviceIds(), 0);
            Device bootDevice = from.getDevices().get(bootDeviceId);
            if (bootDevice != null) {
                try {
                    DriveInfo drive = this.cache.getUnchecked(bootDevice.getDriveUuid());
                    imageId = drive.getName();
                }
                catch (NullPointerException e) {
                    this.logger.debug("drive %s not found", bootDevice.getDriveUuid());
                }
                catch (UncheckedExecutionException e) {
                    this.logger.warn(e, "error finding drive %s: %s", bootDevice.getDriveUuid(), e.getMessage());
                }
            }
            return imageId;
        }
    }

    @Singleton
    public static final class DeviceToVolume
    implements Function<Device, Volume> {
        @Resource
        protected Logger logger = Logger.NULL;
        private final LoadingCache<String, DriveInfo> cache;

        @Inject
        public DeviceToVolume(LoadingCache<String, DriveInfo> cache) {
            this.cache = Preconditions.checkNotNull(cache, "cache");
        }

        @Override
        public Volume apply(Device input) {
            VolumeBuilder builder = new VolumeBuilder();
            builder.id(input.getId());
            try {
                DriveInfo drive = this.cache.getUnchecked(input.getDriveUuid());
                builder.size(Float.valueOf((float)(drive.getSize() / 1024L) / 1024.0f));
            }
            catch (NullPointerException e) {
                this.logger.debug("drive %s not found", input.getDriveUuid());
            }
            catch (UncheckedExecutionException e) {
                this.logger.warn(e, "error finding drive %s: %s", input.getDriveUuid(), e.getMessage());
            }
            return new VolumeBuilder().durable(true).type(Volume.Type.NAS).build();
        }
    }
}

