/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.elasticstack.domain.DriveMetrics;
import org.jclouds.elasticstack.domain.ServerMetrics;

@Singleton
public class MapToServerMetrics
implements Function<Map<String, String>, ServerMetrics> {
    private final Function<Map<String, String>, Map<String, ? extends DriveMetrics>> mapToDriveMetrics;

    @Inject
    public MapToServerMetrics(Function<Map<String, String>, Map<String, ? extends DriveMetrics>> mapToDriveMetrics) {
        this.mapToDriveMetrics = mapToDriveMetrics;
    }

    @Override
    public ServerMetrics apply(Map<String, String> from) {
        ServerMetrics.Builder metricsBuilder = new ServerMetrics.Builder();
        if (from.containsKey("tx:packets")) {
            metricsBuilder.txPackets(new Long(from.get("tx:packets")));
        }
        if (from.containsKey("tx")) {
            metricsBuilder.tx(new Long(from.get("tx")));
        }
        if (from.containsKey("rx:packets")) {
            metricsBuilder.rxPackets(new Long(from.get("rx:packets")));
        }
        if (from.containsKey("rx")) {
            metricsBuilder.rx(new Long(from.get("rx")));
        }
        metricsBuilder.driveMetrics(this.mapToDriveMetrics.apply(from));
        ServerMetrics metrics = metricsBuilder.build();
        return metrics;
    }
}

