/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.epc.config;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.ec2.compute.config.EC2ComputeServiceContextModule;
import org.jclouds.ec2.compute.strategy.ReviseParsedImage;
import org.jclouds.epc.strategy.EucalyptusPartnerCloudReviseParsedImage;

public class EucalyptusPartnerCloudComputeServiceContextModule
extends EC2ComputeServiceContextModule {
    @Override
    protected TemplateBuilder provideTemplate(Injector injector, TemplateBuilder template) {
        String virt = injector.getInstance(Key.get(String.class, (Annotation)Names.named("eucalyptus-partnercloud-ec2.virtualization-type")));
        return template.osFamily(OsFamily.UBUNTU).locationId(virt + "-cluster");
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(ReviseParsedImage.class).to(EucalyptusPartnerCloudReviseParsedImage.class);
    }
}

