/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.MutableStorageMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.HttpGetOptionsListToGetOptions;
import org.jclouds.blobstore.internal.BaseAsyncBlobStore;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.IfDirectoryReturnNameStrategy;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.DateService;
import org.jclouds.domain.Location;
import org.jclouds.filesystem.predicates.validators.FilesystemContainerNameValidator;
import org.jclouds.filesystem.strategy.FilesystemStorageStrategy;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.options.HttpRequestOptions;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.BaseMutableContentMetadata;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.ParamValidators;

public class FilesystemAsyncBlobStore
extends BaseAsyncBlobStore {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final DateService dateService;
    protected final Crypto crypto;
    protected final HttpGetOptionsListToGetOptions httpGetOptionsConverter;
    protected final IfDirectoryReturnNameStrategy ifDirectoryReturnName;
    protected final FilesystemStorageStrategy storageStrategy;

    @Inject
    protected FilesystemAsyncBlobStore(BlobStoreContext context, DateService dateService, Crypto crypto, HttpGetOptionsListToGetOptions httpGetOptionsConverter, IfDirectoryReturnNameStrategy ifDirectoryReturnName, BlobUtils blobUtils, @Named(value="jclouds.user-threads") ExecutorService service, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, FilesystemStorageStrategy storageStrategy) {
        super(context, blobUtils, service, defaultLocation, locations);
        this.dateService = dateService;
        this.crypto = crypto;
        this.httpGetOptionsConverter = httpGetOptionsConverter;
        this.ifDirectoryReturnName = ifDirectoryReturnName;
        this.storageStrategy = Preconditions.checkNotNull(storageStrategy, "Storage strategy");
    }

    @Override
    public ListenableFuture<PageSet<? extends StorageMetadata>> list(final String container, ListContainerOptions options) {
        if (!this.containerExistsSyncImpl(container)) {
            return Futures.immediateFailedFuture(this.cnfe(container));
        }
        Iterable<String> blobBelongingToContainer = null;
        try {
            blobBelongingToContainer = this.storageStrategy.getBlobKeysInsideContainer(container);
        }
        catch (IOException e) {
            this.logger.error(e, "An error occurred loading blobs contained into container %s", container);
            Throwables.propagate(e);
        }
        SortedSet<StorageMetadata> contents = Sets.newTreeSet(Iterables.transform(blobBelongingToContainer, new Function<String, StorageMetadata>(){

            @Override
            public StorageMetadata apply(String key) {
                Blob oldBlob = FilesystemAsyncBlobStore.this.loadFileBlob(container, key);
                Preconditions.checkState(oldBlob != null, "blob " + key + " is not present although it was in the list of " + container);
                Preconditions.checkState(oldBlob.getMetadata() != null, "blob " + container + "/" + key + " has no metadata");
                MutableBlobMetadata md = FilesystemAsyncBlobStore.copy(oldBlob.getMetadata());
                String directoryName = FilesystemAsyncBlobStore.this.ifDirectoryReturnName.execute(md);
                if (directoryName != null) {
                    md.setName(directoryName);
                    md.setType(StorageType.RELATIVE_PATH);
                }
                return md;
            }
        }));
        String marker = null;
        if (options != null) {
            String delimiter;
            String prefix;
            if (options.getMarker() != null) {
                final String finalMarker = options.getMarker();
                StorageMetadata lastMarkerMetadata = Iterables.find(contents, new Predicate<StorageMetadata>(){

                    @Override
                    public boolean apply(StorageMetadata metadata) {
                        return metadata.getName().equals(finalMarker);
                    }
                });
                contents = contents.tailSet(lastMarkerMetadata);
                contents.remove(lastMarkerMetadata);
            }
            if ((prefix = options.getDir()) != null) {
                contents = Sets.newTreeSet(Sets.filter(contents, new Predicate<StorageMetadata>(){

                    @Override
                    public boolean apply(StorageMetadata o) {
                        return o != null && o.getName().startsWith(prefix) && !o.getName().equals(prefix);
                    }
                }));
            }
            Integer maxResults = options.getMaxResults() != null ? options.getMaxResults() : 1000;
            if (contents.size() > 0) {
                SortedSet<StorageMetadata> contentsSlice = FilesystemAsyncBlobStore.firstSliceOfSize(contents, maxResults);
                marker = !contentsSlice.contains(contents.last()) ? contentsSlice.last().getName() : null;
                contents = contentsSlice;
            }
            String string = delimiter = options.isRecursive() ? null : File.separator;
            if (delimiter != null) {
                TreeSet commonPrefixes = null;
                Iterable<String> iterable = Iterables.transform(contents, new CommonPrefixes(prefix != null ? prefix : null, delimiter));
                commonPrefixes = iterable != null ? Sets.newTreeSet(iterable) : new TreeSet();
                commonPrefixes.remove("NO_PREFIX");
                contents = Sets.newTreeSet(Sets.filter(contents, new DelimiterFilter(prefix != null ? prefix : null, delimiter)));
                Iterables.addAll(contents, Iterables.transform(commonPrefixes, new Function<String, StorageMetadata>(){

                    @Override
                    public StorageMetadata apply(String o) {
                        MutableStorageMetadataImpl md = new MutableStorageMetadataImpl();
                        md.setType(StorageType.RELATIVE_PATH);
                        md.setName(o);
                        return md;
                    }
                }));
            }
            if (!options.isDetailed()) {
                for (StorageMetadata md : contents) {
                    md.getUserMetadata().clear();
                }
            }
        }
        return Futures.immediateFuture(new PageSetImpl<StorageMetadata>(contents, marker));
    }

    private ContainerNotFoundException cnfe(String name) {
        return new ContainerNotFoundException(name, String.format("container %s not in filesystem", name));
    }

    public static MutableBlobMetadata copy(MutableBlobMetadata in) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream os = new ObjectOutputStream(bout);
            os.writeObject(in);
            ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
            MutableBlobMetadata metadata = (MutableBlobMetadata)is.readObject();
            FilesystemAsyncBlobStore.convertUserMetadataKeysToLowercase(metadata);
            metadata.setContentMetadata(BaseMutableContentMetadata.fromContentMetadata(in.getContentMetadata().toBuilder().build()));
            return metadata;
        }
        catch (Exception e) {
            Throwables.propagate(e);
            assert (false) : "exception should have propagated: " + e;
            return null;
        }
    }

    private static void convertUserMetadataKeysToLowercase(MutableBlobMetadata metadata) {
        HashMap<String, String> lowerCaseUserMetadata = Maps.newHashMap();
        for (Map.Entry<String, String> entry : metadata.getUserMetadata().entrySet()) {
            lowerCaseUserMetadata.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        metadata.setUserMetadata(lowerCaseUserMetadata);
    }

    public static MutableBlobMetadata copy(MutableBlobMetadata in, String newKey) {
        MutableBlobMetadata newMd = FilesystemAsyncBlobStore.copy(in);
        newMd.setName(newKey);
        return newMd;
    }

    @Override
    public ListenableFuture<Void> removeBlob(String container, String key) {
        this.storageStrategy.removeBlob(container, key);
        return Futures.immediateFuture(null);
    }

    @Override
    public ListenableFuture<Boolean> containerExists(String containerName) {
        boolean exists = this.containerExistsSyncImpl(containerName);
        return Futures.immediateFuture(exists);
    }

    @Override
    public ListenableFuture<PageSet<? extends StorageMetadata>> list() {
        Iterable<String> containers = this.storageStrategy.getAllContainerNames();
        return Futures.immediateFuture(new PageSetImpl<StorageMetadata>(Iterables.transform(containers, new Function<String, StorageMetadata>(){

            @Override
            public StorageMetadata apply(String name) {
                MutableStorageMetadata cmd = FilesystemAsyncBlobStore.this.create();
                cmd.setName(name);
                cmd.setType(StorageType.CONTAINER);
                return cmd;
            }
        }), null));
    }

    protected MutableStorageMetadata create() {
        return new MutableStorageMetadataImpl();
    }

    @Override
    @Path(value="{container}")
    public ListenableFuture<Boolean> createContainerInLocation(Location location, @PathParam(value="container") @ParamValidators(value={FilesystemContainerNameValidator.class}) String name) {
        boolean result = this.storageStrategy.createContainer(name);
        return Futures.immediateFuture(result);
    }

    public String getFirstQueryOrNull(String string, @Nullable HttpRequestOptions options) {
        if (options == null) {
            return null;
        }
        Collection<String> values = options.buildQueryParameters().get(string);
        return values != null && values.size() >= 1 ? values.iterator().next() : null;
    }

    private Blob loadFileBlob(String container, String key) {
        this.logger.debug("Opening blob in container: %s - %s", container, key);
        BlobBuilder builder = this.blobUtils.blobBuilder();
        builder.name(key);
        File file = this.storageStrategy.getFileForBlobKey(container, key);
        try {
            builder.payload(file).calculateMD5();
        }
        catch (IOException e) {
            this.logger.error("An error occurred calculating MD5 for blob %s from container ", key, container);
            Throwables.propagateIfPossible(e);
        }
        Blob blob = builder.build();
        if (blob.getPayload().getContentMetadata().getContentMD5() != null) {
            blob.getMetadata().setETag(CryptoStreams.hex(blob.getPayload().getContentMetadata().getContentMD5()));
        }
        return blob;
    }

    public static <T extends Comparable<?>> SortedSet<T> firstSliceOfSize(Iterable<T> elements, int size) {
        List<List<T>> slices = Lists.partition(Lists.newArrayList(elements), size);
        return Sets.newTreeSet((Iterable)slices.get(0));
    }

    public static HttpResponseException returnResponseException(int code) {
        HttpResponse response = null;
        response = new HttpResponse(code, null, null);
        return new HttpResponseException(new HttpCommand(){

            @Override
            public int getRedirectCount() {
                return 0;
            }

            @Override
            public int incrementRedirectCount() {
                return 0;
            }

            @Override
            public boolean isReplayable() {
                return false;
            }

            @Override
            public Exception getException() {
                return null;
            }

            @Override
            public int getFailureCount() {
                return 0;
            }

            @Override
            public int incrementFailureCount() {
                return 0;
            }

            @Override
            public void setException(Exception exception) {
            }

            @Override
            public HttpRequest getCurrentRequest() {
                return new HttpRequest("GET", URI.create("http://stub"));
            }

            @Override
            public void setCurrentRequest(HttpRequest request) {
            }
        }, response);
    }

    @Override
    public ListenableFuture<String> putBlob(String containerName, Blob object) {
        String blobKey = object.getMetadata().getName();
        this.logger.debug("Put object with key [%s] to container [%s]", blobKey, containerName);
        String eTag = this.getEtag(object);
        try {
            this.storageStrategy.writePayloadOnFile(containerName, blobKey, object.getPayload());
        }
        catch (IOException e) {
            this.logger.error(e, "An error occurred storing the new object with name [%s] to container [%s].", blobKey, containerName);
            Throwables.propagate(e);
        }
        return Futures.immediateFuture(eTag);
    }

    @Override
    public ListenableFuture<Boolean> blobExists(String containerName, String key) {
        return Futures.immediateFuture(this.storageStrategy.blobExists(containerName, key));
    }

    @Override
    public ListenableFuture<Blob> getBlob(String containerName, String key, GetOptions options) {
        this.logger.debug("Retrieving blob with key %s from container %s", key, containerName);
        if (!this.containerExistsSyncImpl(containerName)) {
            this.logger.debug("Container %s does not exist", containerName);
            return Futures.immediateFailedFuture(this.cnfe(containerName));
        }
        if (!this.storageStrategy.blobExists(containerName, key)) {
            this.logger.debug("Item %s does not exist in container %s", key, containerName);
            return Futures.immediateFuture(null);
        }
        Blob blob = this.loadFileBlob(containerName, key);
        if (options != null) {
            if (options.getIfMatch() != null && !blob.getMetadata().getETag().equals(options.getIfMatch())) {
                return Futures.immediateFailedFuture(FilesystemAsyncBlobStore.returnResponseException(412));
            }
            if (options.getIfNoneMatch() != null && blob.getMetadata().getETag().equals(options.getIfNoneMatch())) {
                return Futures.immediateFailedFuture(FilesystemAsyncBlobStore.returnResponseException(304));
            }
            if (options.getIfModifiedSince() != null) {
                Date modifiedSince = options.getIfModifiedSince();
                if (blob.getMetadata().getLastModified().before(modifiedSince)) {
                    HttpResponse response = new HttpResponse(304, null, null);
                    return Futures.immediateFailedFuture(new HttpResponseException(String.format("%1$s is before %2$s", blob.getMetadata().getLastModified(), modifiedSince), null, response));
                }
            }
            if (options.getIfUnmodifiedSince() != null) {
                Date unmodifiedSince = options.getIfUnmodifiedSince();
                if (blob.getMetadata().getLastModified().after(unmodifiedSince)) {
                    HttpResponse response = new HttpResponse(412, null, null);
                    return Futures.immediateFailedFuture(new HttpResponseException(String.format("%1$s is after %2$s", blob.getMetadata().getLastModified(), unmodifiedSince), null, response));
                }
            }
            if (options.getRanges() != null && options.getRanges().size() > 0) {
                byte[] data;
                try {
                    data = ByteStreams.toByteArray(blob.getPayload().getInput());
                }
                catch (IOException e) {
                    return Futures.immediateFailedFuture(new RuntimeException(e));
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                for (String s : options.getRanges()) {
                    if (s.startsWith("-")) {
                        int length = Integer.parseInt(s.substring(1));
                        out.write(data, data.length - length, length);
                        continue;
                    }
                    if (s.endsWith("-")) {
                        int offset = Integer.parseInt(s.substring(0, s.length() - 1));
                        out.write(data, offset, data.length - offset);
                        continue;
                    }
                    if (s.contains("-")) {
                        String[] firstLast = s.split("\\-");
                        int offset = Integer.parseInt(firstLast[0]);
                        int last = Integer.parseInt(firstLast[1]);
                        int length = last - offset + 1;
                        out.write(data, offset, length);
                        continue;
                    }
                    return Futures.immediateFailedFuture(new IllegalArgumentException("first and last were null!"));
                }
                blob.setPayload(out.toByteArray());
                blob.getMetadata().getContentMetadata().setContentLength(new Long(data.length));
            }
        }
        Preconditions.checkNotNull(blob.getPayload(), "payload " + blob);
        return Futures.immediateFuture(blob);
    }

    @Override
    public ListenableFuture<BlobMetadata> blobMetadata(String container, String key) {
        try {
            Blob blob = (Blob)this.getBlob(container, key).get();
            return Futures.immediateFuture(blob != null ? blob.getMetadata() : null);
        }
        catch (Exception e) {
            if (Iterables.size(Iterables.filter(Throwables.getCausalChain(e), KeyNotFoundException.class)) >= 1) {
                return Futures.immediateFuture(null);
            }
            return Futures.immediateFailedFuture(e);
        }
    }

    @Override
    protected boolean deleteAndVerifyContainerGone(String container) {
        this.storageStrategy.deleteContainer(container);
        return this.containerExistsSyncImpl(container);
    }

    @Override
    public ListenableFuture<Void> deleteContainer(String container) {
        this.deleteAndVerifyContainerGone(container);
        return Futures.immediateFuture(null);
    }

    private boolean containerExistsSyncImpl(String containerName) {
        return this.storageStrategy.containerExists(containerName);
    }

    private String getEtag(Blob object) {
        try {
            Payloads.calculateMD5(object, this.crypto.md5());
        }
        catch (IOException ex) {
            this.logger.error(ex, "An error occurred calculating MD5 for object with name %s.", object.getMetadata().getName());
            Throwables.propagate(ex);
        }
        String eTag = CryptoStreams.hex(object.getPayload().getContentMetadata().getContentMD5());
        return eTag;
    }

    @Override
    public ListenableFuture<String> putBlob(String container, Blob blob, PutOptions options) {
        return this.putBlob(container, blob);
    }

    @Override
    public ListenableFuture<Boolean> createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        if (options.isPublicRead()) {
            throw new UnsupportedOperationException("publicRead");
        }
        return this.createContainerInLocation(location, container);
    }

    protected static class CommonPrefixes
    implements Function<StorageMetadata, String> {
        private final String prefix;
        private final String delimiter;
        public static final String NO_PREFIX = "NO_PREFIX";

        public CommonPrefixes(String prefix, String delimiter) {
            this.prefix = prefix;
            this.delimiter = delimiter;
        }

        @Override
        public String apply(StorageMetadata metadata) {
            String working = metadata.getName();
            if (this.prefix != null) {
                String toMatch;
                String string = toMatch = this.prefix.endsWith("/") ? this.prefix : this.prefix + this.delimiter;
                if (working.startsWith(toMatch)) {
                    working = working.replaceFirst(toMatch, "");
                }
            }
            if (working.contains(this.delimiter)) {
                return working.substring(0, working.indexOf(this.delimiter));
            }
            return NO_PREFIX;
        }
    }

    protected static class DelimiterFilter
    implements Predicate<StorageMetadata> {
        private final String prefix;
        private final String delimiter;

        public DelimiterFilter(String prefix, String delimiter) {
            this.prefix = prefix;
            this.delimiter = delimiter;
        }

        @Override
        public boolean apply(StorageMetadata metadata) {
            String toMatch;
            if (this.prefix == null) {
                return metadata.getName().indexOf(this.delimiter) == -1;
            }
            String string = toMatch = this.prefix.endsWith("/") ? this.prefix : this.prefix + this.delimiter;
            if (metadata.getName().startsWith(toMatch)) {
                String unprefixedName = metadata.getName().replaceFirst(toMatch, "");
                if (unprefixedName.equals("")) {
                    return false;
                }
                return unprefixedName.indexOf(this.delimiter) == -1;
            }
            return false;
        }
    }
}

