/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem.strategy.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.filesystem.predicates.validators.FilesystemBlobKeyValidator;
import org.jclouds.filesystem.predicates.validators.FilesystemContainerNameValidator;
import org.jclouds.filesystem.strategy.FilesystemStorageStrategy;
import org.jclouds.io.Payload;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.ParamValidators;

public class FilesystemStorageStrategyImpl
implements FilesystemStorageStrategy {
    private static final String BACK_SLASH = "\\";
    @Resource
    protected Logger logger = Logger.NULL;
    protected final Provider<BlobBuilder> blobBuilders;
    protected final String baseDirectory;
    protected final FilesystemContainerNameValidator filesystemContainerNameValidator;
    protected final FilesystemBlobKeyValidator filesystemBlobKeyValidator;

    @Inject
    protected FilesystemStorageStrategyImpl(Provider<BlobBuilder> blobBuilders, @Named(value="jclouds.filesystem.basedir") String baseDir, FilesystemContainerNameValidator filesystemContainerNameValidator, FilesystemBlobKeyValidator filesystemBlobKeyValidator) {
        this.blobBuilders = Preconditions.checkNotNull(blobBuilders, "filesystem storage strategy blobBuilders");
        this.baseDirectory = Preconditions.checkNotNull(baseDir, "filesystem storage strategy base directory");
        this.filesystemContainerNameValidator = Preconditions.checkNotNull(filesystemContainerNameValidator, "filesystem container name validator");
        this.filesystemBlobKeyValidator = Preconditions.checkNotNull(filesystemBlobKeyValidator, "filesystem blob key validator");
    }

    @Override
    public boolean containerExists(String container) {
        this.filesystemContainerNameValidator.validate(container);
        return this.directoryExists(container, null);
    }

    @Override
    public boolean blobExists(String container, String key) {
        this.filesystemContainerNameValidator.validate(container);
        this.filesystemBlobKeyValidator.validate(key);
        return this.buildPathAndChecksIfFileExists(container, key);
    }

    @Override
    public boolean createContainer(String container) {
        this.logger.debug("Creating container %s", container);
        this.filesystemContainerNameValidator.validate(container);
        return this.createDirectoryWithResult(container, null);
    }

    @Override
    public void deleteContainer(String container) {
        this.filesystemContainerNameValidator.validate(container);
        this.deleteDirectory(container, null);
    }

    @Override
    public void clearContainer(String container) {
        this.filesystemContainerNameValidator.validate(container);
        this.clearContainer(container, ListContainerOptions.Builder.recursive());
    }

    @Override
    public void clearContainer(String container, ListContainerOptions options) {
        this.filesystemContainerNameValidator.validate(container);
        try {
            File containerFile = this.openFolder(container);
            File[] children = containerFile.listFiles();
            if (null != children) {
                for (File child : children) {
                    FileUtils.forceDelete((File)child);
                }
            }
        }
        catch (IOException e) {
            this.logger.error(e, "An error occurred while clearing container %s", container);
            Throwables.propagate(e);
        }
    }

    @Override
    public Blob newBlob(@ParamValidators(value={FilesystemBlobKeyValidator.class}) String name) {
        this.filesystemBlobKeyValidator.validate(name);
        return this.blobBuilders.get().name(name).build();
    }

    @Override
    public void removeBlob(String container, String blobKey) {
        this.filesystemContainerNameValidator.validate(container);
        this.filesystemBlobKeyValidator.validate(blobKey);
        String fileName = this.buildPathStartingFromBaseDir(container, blobKey);
        this.logger.debug("Deleting blob %s", fileName);
        File fileToBeDeleted = new File(fileName);
        fileToBeDeleted.delete();
        this.removeDirectoriesTreeOfBlobKey(container, blobKey);
    }

    @Override
    public Iterable<String> getAllContainerNames() {
        Iterable<String> containers = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new FileIterator(FilesystemStorageStrategyImpl.this.buildPathStartingFromBaseDir(new String[0]), (FileFilter)DirectoryFileFilter.INSTANCE);
            }
        };
        return containers;
    }

    @Override
    public File getFileForBlobKey(String container, String blobKey) {
        this.filesystemContainerNameValidator.validate(container);
        this.filesystemBlobKeyValidator.validate(blobKey);
        String fileName = this.buildPathStartingFromBaseDir(container, blobKey);
        File blobFile = new File(fileName);
        return blobFile;
    }

    @Override
    public void writePayloadOnFile(String container, String blobKey, Payload payload) throws IOException {
        FileOutputStream output;
        block7: {
            this.filesystemContainerNameValidator.validate(container);
            this.filesystemBlobKeyValidator.validate(blobKey);
            File outputFile = this.getFileForBlobKey(container, blobKey);
            if (payload.getRawContent().equals(outputFile)) {
                return;
            }
            output = null;
            try {
                Files.createParentDirs(outputFile);
                if (payload.getRawContent() instanceof File) {
                    Files.copy((File)File.class.cast(payload.getRawContent()), outputFile);
                    break block7;
                }
                output = new FileOutputStream(outputFile);
                payload.writeTo(output);
            }
            catch (IOException ex) {
                try {
                    if (outputFile != null) {
                        outputFile.delete();
                    }
                    throw ex;
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(output);
                    payload.release();
                    throw throwable;
                }
            }
        }
        Closeables.closeQuietly(output);
        payload.release();
    }

    @Override
    public Iterable<String> getBlobKeysInsideContainer(String container) throws IOException {
        this.filesystemContainerNameValidator.validate(container);
        if (!this.containerExists(container)) {
            return new HashSet<String>();
        }
        File containerFile = this.openFolder(container);
        final int containerPathLenght = containerFile.getAbsolutePath().length() + 1;
        HashSet<String> blobNames = new HashSet<String>(){
            private static final long serialVersionUID = 3152191346558570795L;

            @Override
            public boolean add(String e) {
                return super.add(e.substring(containerPathLenght));
            }
        };
        this.populateBlobKeysInContainer(containerFile, (Set<String>)blobNames);
        return blobNames;
    }

    @Override
    public boolean directoryExists(String container, String directory) {
        return this.buildPathAndChecksIfDirectoryExists(container, directory);
    }

    @Override
    public void createDirectory(String container, String directory) {
        this.createDirectoryWithResult(container, directory);
    }

    @Override
    public void deleteDirectory(String container, String directory) {
        String fullDirPath = this.buildPathStartingFromBaseDir(container, directory);
        try {
            FileUtils.forceDelete((File)new File(fullDirPath));
        }
        catch (IOException ex) {
            this.logger.error("An error occurred removing directory %s.", fullDirPath);
            Throwables.propagate(ex);
        }
    }

    @Override
    public long countBlobs(String container, ListContainerOptions options) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private boolean buildPathAndChecksIfFileExists(String ... tokens) {
        String path = this.buildPathStartingFromBaseDir(tokens);
        File file = new File(path);
        boolean exists = file.exists() || file.isFile();
        return exists;
    }

    private boolean buildPathAndChecksIfDirectoryExists(String ... tokens) {
        String path = this.buildPathStartingFromBaseDir(tokens);
        File file = new File(path);
        boolean exists = file.exists() || file.isDirectory();
        return exists;
    }

    protected String buildPathStartingFromBaseDir(String ... pathTokens) {
        String normalizedToken = this.removeFileSeparatorFromBorders(this.normalize(this.baseDirectory), true);
        StringBuilder completePath = new StringBuilder(normalizedToken);
        if (pathTokens != null && pathTokens.length > 0) {
            for (int i = 0; i < pathTokens.length; ++i) {
                if (pathTokens[i] == null) continue;
                normalizedToken = this.removeFileSeparatorFromBorders(this.normalize(pathTokens[i]), false);
                completePath.append(File.separator).append(normalizedToken);
            }
        }
        return completePath.toString();
    }

    private String normalize(String pathToBeNormalized) {
        if (null != pathToBeNormalized && pathToBeNormalized.contains(BACK_SLASH) && !BACK_SLASH.equals(File.separator)) {
            return pathToBeNormalized.replaceAll(BACK_SLASH, File.separator);
        }
        return pathToBeNormalized;
    }

    private String removeFileSeparatorFromBorders(String pathToBeCleaned, boolean onlyTrailing) {
        if (null == pathToBeCleaned || pathToBeCleaned.equals("")) {
            return pathToBeCleaned;
        }
        int beginIndex = 0;
        int endIndex = pathToBeCleaned.length();
        if (!onlyTrailing && pathToBeCleaned.substring(0, 1).equals(File.separator)) {
            beginIndex = 1;
        }
        if (pathToBeCleaned.substring(pathToBeCleaned.length() - 1).equals(File.separator)) {
            --endIndex;
        }
        return pathToBeCleaned.substring(beginIndex, endIndex);
    }

    private void removeDirectoriesTreeOfBlobKey(String container, String blobKey) {
        File directory;
        String[] children;
        String normalizedBlobKey = this.normalize(blobKey);
        if (!normalizedBlobKey.contains(File.separator)) {
            return;
        }
        File file = new File(normalizedBlobKey);
        String parentPath = file.getParent();
        if (!(null == parentPath && !"".equals(parentPath) || null != (children = (directory = new File(this.buildPathStartingFromBaseDir(container, parentPath))).list()) && children.length != 0)) {
            directory.delete();
            this.removeDirectoriesTreeOfBlobKey(container, parentPath);
        }
    }

    private File openFolder(String folderName) throws IOException {
        String baseFolderName = this.buildPathStartingFromBaseDir(folderName);
        File folder = new File(baseFolderName);
        if (folder.exists() && !folder.isDirectory()) {
            throw new IOException("Resource " + baseFolderName + " isn't a folder.");
        }
        return folder;
    }

    private void populateBlobKeysInContainer(File directory, Set<String> blobNames) {
        File[] children;
        for (File child : children = directory.listFiles()) {
            if (child.isFile()) {
                blobNames.add(child.getAbsolutePath());
                continue;
            }
            if (!child.isDirectory()) continue;
            this.populateBlobKeysInContainer(child, blobNames);
        }
    }

    protected boolean createDirectoryWithResult(String container, String directory) {
        String directoryFullName = this.buildPathStartingFromBaseDir(container, directory);
        this.logger.debug("Creating directory %s", directoryFullName);
        if (this.buildPathAndChecksIfDirectoryExists(container, directory)) {
            this.logger.debug("Directory %s already exists", directoryFullName);
            return false;
        }
        File directoryToCreate = new File(directoryFullName);
        boolean result = directoryToCreate.mkdirs();
        return result;
    }

    private class FileIterator
    implements Iterator<String> {
        int currentFileIndex = 0;
        File[] children = new File[0];
        File currentFile = null;

        public FileIterator(String fileName, FileFilter filter) {
            File file = new File(fileName);
            if (file.exists() && file.isDirectory()) {
                this.children = file.listFiles(filter);
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentFileIndex < this.children.length;
        }

        @Override
        public String next() {
            this.currentFile = this.children[this.currentFileIndex++];
            return this.currentFile.getName();
        }

        @Override
        public void remove() {
            if (this.currentFile != null && this.currentFile.exists() && !this.currentFile.delete()) {
                throw new RuntimeException("An error occurred deleting " + this.currentFile.getName());
            }
        }
    }
}

