/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.Throwables2;

public class ExceptionToValueOrPropagate<E extends Exception, T>
implements Function<Exception, T> {
    private final Class<E> matchingClass;
    private final T value;

    public ExceptionToValueOrPropagate(Class<E> matchingClass, @Nullable T value) {
        this.matchingClass = Preconditions.checkNotNull(matchingClass, "matchingClass");
        this.value = value;
    }

    @Override
    public T apply(Exception from) {
        Preconditions.checkNotNull(from, "exception");
        List<Throwable> throwables = Throwables.getCausalChain(from);
        Iterable<E> matchingThrowables = Iterables.filter(throwables, this.matchingClass);
        if (Iterables.size(matchingThrowables) >= 1) {
            return this.value;
        }
        return Throwables2.propagateOrNull(from);
    }
}

