/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

public class BindNamesToQueryParams
implements Binder {
    private final Provider<UriBuilder> builder;

    @Inject
    BindNamesToQueryParams(Provider<UriBuilder> builder) {
        this.builder = builder;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input is null") instanceof String[], "this binder is only valid for String[] arguments");
        String[] names = (String[])input;
        return ModifyRequest.addQueryParam(request, "name", ImmutableList.copyOf(names), this.builder.get());
    }
}

