/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.binders;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

public class BindRealIpPortPairsToQueryParams
implements Binder {
    private final Provider<UriBuilder> builder;

    @Inject
    BindRealIpPortPairsToQueryParams(Provider<UriBuilder> builder) {
        this.builder = builder;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input is null") instanceof List, "this binder is only valid for a List argument");
        List ipPortPairs = (List)input;
        int i = 0;
        for (IpPortPair ipPortPair : ipPortPairs) {
            Preconditions.checkNotNull(ipPortPair.getIp(), "There must be an IP address defined");
            Preconditions.checkNotNull(ipPortPair.getIp().getIp(), "There must be an IP address defined in Ip object");
            Preconditions.checkState(ipPortPair.getPort() > 0, "The port number must be a positive integer");
            request = ModifyRequest.addQueryParam(request, "realiplist." + i + ".ip", ipPortPair.getIp().getIp(), this.builder.get());
            request = ModifyRequest.addQueryParam(request, "realiplist." + i + ".port", String.valueOf(ipPortPair.getPort()), this.builder.get());
            ++i;
        }
        return request;
    }
}

