/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.binders;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

public class BindVirtualIpPortPairToQueryParams
implements Binder {
    private final Provider<UriBuilder> builder;

    @Inject
    BindVirtualIpPortPairToQueryParams(Provider<UriBuilder> builder) {
        this.builder = builder;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input is null") instanceof IpPortPair, "this binder is only valid for a IpPortPair argument");
        IpPortPair ipPortPair = (IpPortPair)input;
        Preconditions.checkNotNull(ipPortPair.getIp(), "There must be an IP address defined");
        Preconditions.checkNotNull(ipPortPair.getIp().getIp(), "There must be an IP address defined in Ip object");
        Preconditions.checkState(ipPortPair.getPort() > 0, "The port number must be a positive integer");
        request = ModifyRequest.addQueryParam(request, "virtualip.ip", ipPortPair.getIp().getIp(), this.builder.get());
        return ModifyRequest.addQueryParam(request, "virtualip.port", String.valueOf(ipPortPair.getPort()), this.builder.get());
    }
}

