/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.gogrid.GoGridAsyncClient;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.compute.functions.OptionToLocation;
import org.jclouds.gogrid.compute.functions.ServerImageToImage;
import org.jclouds.gogrid.compute.functions.ServerToNodeMetadata;
import org.jclouds.gogrid.compute.options.GoGridTemplateOptions;
import org.jclouds.gogrid.compute.strategy.GoGridComputeServiceAdapter;
import org.jclouds.gogrid.compute.suppliers.GoGridDefaultLocationSupplier;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.domain.ServerState;

public class GoGridComputeServiceContextModule
extends ComputeServiceAdapterContextModule<GoGridClient, GoGridAsyncClient, Server, Hardware, ServerImage, Option> {
    @VisibleForTesting
    static final Map<ServerState, NodeState> serverStateToNodeState = ImmutableMap.builder().put(ServerState.ON, NodeState.RUNNING).put(ServerState.STARTING, NodeState.PENDING).put(ServerState.OFF, NodeState.SUSPENDED).put(ServerState.STOPPING, NodeState.PENDING).put(ServerState.RESTARTING, NodeState.PENDING).put(ServerState.SAVING, NodeState.PENDING).put(ServerState.UNRECOGNIZED, NodeState.UNRECOGNIZED).put(ServerState.RESTORING, NodeState.PENDING).put(ServerState.UPDATING, NodeState.PENDING).build();

    public GoGridComputeServiceContextModule() {
        super(GoGridClient.class, GoGridAsyncClient.class);
    }

    @Override
    protected TemplateBuilder provideTemplate(Injector injector, TemplateBuilder template) {
        return template.osFamily(OsFamily.UBUNTU).osVersionMatches("1[10].[10][04]").imageNameMatches(".*w/ None.*");
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(new TypeLiteral<ComputeServiceAdapter<Server, Hardware, ServerImage, Option>>(){}).to(GoGridComputeServiceAdapter.class);
        this.bind(new TypeLiteral<Function<Server, NodeMetadata>>(){}).to(ServerToNodeMetadata.class);
        this.bind(new TypeLiteral<Function<ServerImage, Image>>(){}).to(ServerImageToImage.class);
        this.bind(new TypeLiteral<Function<Option, Location>>(){}).to(OptionToLocation.class);
        this.bind(new TypeLiteral<Function<Hardware, Hardware>>(){}).to(IdentityFunction.class);
        this.bind(new TypeLiteral<Supplier<Location>>(){}).to(GoGridDefaultLocationSupplier.class);
        this.bind(TemplateOptions.class).to(GoGridTemplateOptions.class);
    }

    @Singleton
    @Provides
    Map<ServerState, NodeState> provideServerToNodeState() {
        return serverStateToNodeState;
    }

    @Singleton
    @Provides
    Function<Hardware, String> provideSizeToRam() {
        return new Function<Hardware, String>(){

            @Override
            public String apply(Hardware hardware) {
                if (hardware.getRam() >= 8192 || ComputeServiceUtils.getCores(hardware) >= 6.0 || ComputeServiceUtils.getSpace(hardware) >= 450.0) {
                    return "8GB";
                }
                if (hardware.getRam() >= 4096 || ComputeServiceUtils.getCores(hardware) >= 3.0 || ComputeServiceUtils.getSpace(hardware) >= 230.0) {
                    return "4GB";
                }
                if (hardware.getRam() >= 2048 || ComputeServiceUtils.getSpace(hardware) >= 110.0) {
                    return "2GB";
                }
                if (hardware.getRam() >= 1024 || ComputeServiceUtils.getSpace(hardware) >= 55.0) {
                    return "1GB";
                }
                return "512MB";
            }
        };
    }
}

