/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.JustProvider;

@Singleton
public class OptionToLocation
extends JustProvider
implements Function<Option, Location> {
    private final Map<String, Set<String>> isoCodesById;
    private final Location provider = (Location)Iterables.getOnlyElement(super.get());

    @Inject
    OptionToLocation(@Iso3166 Set<String> isoCodes, @Provider String providerName, @Provider URI endpoint, @Iso3166 Map<String, Set<String>> isoCodesById) {
        super(providerName, endpoint, isoCodes);
        this.isoCodesById = Preconditions.checkNotNull(isoCodesById, "isoCodesById");
    }

    @Override
    public Location apply(Option from) {
        LocationBuilder builder = new LocationBuilder().scope(LocationScope.ZONE).id(from.getId() + "").description(from.getDescription()).parent(this.provider);
        if (this.isoCodesById.containsKey(from.getId() + "")) {
            builder.iso3166Codes((Iterable<String>)this.isoCodesById.get(from.getId() + ""));
        }
        return builder.build();
    }
}

