/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provides;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.jclouds.date.TimeStamp;
import org.jclouds.gogrid.GoGridAsyncClient;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.config.GoGridParserModule;
import org.jclouds.gogrid.handlers.GoGridErrorHandler;
import org.jclouds.gogrid.services.GridImageAsyncClient;
import org.jclouds.gogrid.services.GridImageClient;
import org.jclouds.gogrid.services.GridIpAsyncClient;
import org.jclouds.gogrid.services.GridIpClient;
import org.jclouds.gogrid.services.GridJobAsyncClient;
import org.jclouds.gogrid.services.GridJobClient;
import org.jclouds.gogrid.services.GridLoadBalancerAsyncClient;
import org.jclouds.gogrid.services.GridLoadBalancerClient;
import org.jclouds.gogrid.services.GridServerAsyncClient;
import org.jclouds.gogrid.services.GridServerClient;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@RequiresHttp
@ConfiguresRestClient
public class GoGridRestClientModule
extends RestClientModule<GoGridClient, GoGridAsyncClient> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(GridServerClient.class, GridServerAsyncClient.class).put(GridJobClient.class, GridJobAsyncClient.class).put(GridIpClient.class, GridIpAsyncClient.class).put(GridLoadBalancerClient.class, GridLoadBalancerAsyncClient.class).put(GridImageClient.class, GridImageAsyncClient.class).build();

    public GoGridRestClientModule() {
        super(GoGridClient.class, GoGridAsyncClient.class, DELEGATE_MAP);
    }

    @Provides
    @TimeStamp
    protected Long provideTimeStamp(@TimeStamp Supplier<Long> cache) {
        return cache.get();
    }

    @Provides
    @TimeStamp
    Supplier<Long> provideTimeStampCache(@Named(value="jclouds.session-interval") long seconds) {
        return Suppliers.memoizeWithExpiration(new Supplier<Long>(){

            @Override
            public Long get() {
                return System.currentTimeMillis() / 1000L;
            }
        }, seconds, TimeUnit.SECONDS);
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(GoGridErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(GoGridErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(GoGridErrorHandler.class);
    }

    @Override
    protected void configure() {
        this.install(new GoGridParserModule());
        super.configure();
    }
}

