/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.primitives.Longs;
import com.google.gson.annotations.SerializedName;
import org.jclouds.gogrid.domain.IpState;
import org.jclouds.gogrid.domain.Option;

public class Ip
implements Comparable<Ip> {
    private long id;
    private String ip;
    private String subnet;
    @SerializedName(value="public")
    private boolean isPublic;
    private IpState state;
    private Option datacenter;

    public Ip() {
    }

    public Ip(String ip) {
        this.ip = ip;
    }

    public Ip(long id, String ip, String subnet, boolean isPublic, IpState state, Option datacenter) {
        this.id = id;
        this.ip = ip;
        this.subnet = subnet;
        this.isPublic = isPublic;
        this.state = state;
        this.datacenter = datacenter;
    }

    public long getId() {
        return this.id;
    }

    public Option getDatacenter() {
        return this.datacenter;
    }

    public String getIp() {
        return this.ip;
    }

    public String getSubnet() {
        return this.subnet;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public IpState getState() {
        return this.state;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ip other = (Ip)obj;
        if (this.datacenter == null ? other.datacenter != null : !this.datacenter.equals(other.datacenter)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        if (this.isPublic != other.isPublic) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals((Object)other.state)) {
            return false;
        }
        return !(this.subnet == null ? other.subnet != null : !this.subnet.equals(other.subnet));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.datacenter == null ? 0 : this.datacenter.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + (this.isPublic ? 1231 : 1237);
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.subnet == null ? 0 : this.subnet.hashCode());
        return result;
    }

    public String toString() {
        return "Ip [datacenter=" + this.datacenter + ", id=" + this.id + ", ip=" + this.ip + ", isPublic=" + this.isPublic + ", state=" + (Object)((Object)this.state) + ", subnet=" + this.subnet + "]";
    }

    @Override
    public int compareTo(Ip o) {
        return Longs.compare(this.id, o.getId());
    }
}

