/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.primitives.Longs;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.jclouds.gogrid.domain.JobProperties;
import org.jclouds.gogrid.domain.JobState;
import org.jclouds.gogrid.domain.ObjectType;
import org.jclouds.gogrid.domain.Option;

public class Job
implements Comparable<Job> {
    private long id;
    private Option command;
    @SerializedName(value="objecttype")
    private ObjectType objectType;
    @SerializedName(value="createdon")
    private Date createdOn;
    @SerializedName(value="lastupdatedon")
    private Date lastUpdatedOn;
    @SerializedName(value="currentstate")
    private JobState currentState;
    private int attempts;
    private String owner;
    private Set<JobProperties> history;
    @SerializedName(value="detail")
    private Map<String, String> details;

    public Job() {
    }

    public Job(long id, Option command, ObjectType objectType, Date createdOn, Date lastUpdatedOn, JobState currentState, int attempts, String owner, SortedSet<JobProperties> history, Map<String, String> details) {
        this.id = id;
        this.command = command;
        this.objectType = objectType;
        this.createdOn = createdOn;
        this.lastUpdatedOn = lastUpdatedOn;
        this.currentState = currentState;
        this.attempts = attempts;
        this.owner = owner;
        this.history = history;
        this.details = details;
    }

    public long getId() {
        return this.id;
    }

    public Option getCommand() {
        return this.command;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public Date getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public JobState getCurrentState() {
        return this.currentState;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public String getOwner() {
        return this.owner;
    }

    public Set<JobProperties> getHistory() {
        return this.history;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        if (this.attempts != job.attempts) {
            return false;
        }
        if (this.id != job.id) {
            return false;
        }
        if (this.command != null ? !this.command.equals(job.command) : job.command != null) {
            return false;
        }
        if (this.createdOn != null ? !this.createdOn.equals(job.createdOn) : job.createdOn != null) {
            return false;
        }
        if (this.currentState != null ? !this.currentState.equals((Object)job.currentState) : job.currentState != null) {
            return false;
        }
        if (this.details != null ? !((Object)this.details).equals(job.details) : job.details != null) {
            return false;
        }
        if (this.history != null ? !((Object)this.history).equals(job.history) : job.history != null) {
            return false;
        }
        if (this.lastUpdatedOn != null ? !this.lastUpdatedOn.equals(job.lastUpdatedOn) : job.lastUpdatedOn != null) {
            return false;
        }
        if (this.objectType != null ? !this.objectType.equals((Object)job.objectType) : job.objectType != null) {
            return false;
        }
        return !(this.owner != null ? !this.owner.equals(job.owner) : job.owner != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
        result = 31 * result + (this.objectType != null ? this.objectType.hashCode() : 0);
        result = 31 * result + (this.createdOn != null ? this.createdOn.hashCode() : 0);
        result = 31 * result + (this.lastUpdatedOn != null ? this.lastUpdatedOn.hashCode() : 0);
        result = 31 * result + (this.currentState != null ? this.currentState.hashCode() : 0);
        result = 31 * result + this.attempts;
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = 31 * result + (this.history != null ? ((Object)this.history).hashCode() : 0);
        result = 31 * result + (this.details != null ? ((Object)this.details).hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(Job o) {
        if (this.createdOn != null && o.getCreatedOn() != null) {
            return Longs.compare(this.createdOn.getTime(), o.getCreatedOn().getTime());
        }
        return Longs.compare(this.id, o.getId());
    }

    public String toString() {
        return "Job{id=" + this.id + ", command=" + this.command + ", objectType=" + (Object)((Object)this.objectType) + ", createdOn=" + this.createdOn + ", lastUpdatedOn=" + this.lastUpdatedOn + ", currentState=" + (Object)((Object)this.currentState) + ", attempts=" + this.attempts + ", owner='" + this.owner + '\'' + ", history=" + this.history + ", details=" + this.details + '}';
    }
}

