/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.primitives.Longs;
import com.google.gson.annotations.SerializedName;
import java.util.Set;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.gogrid.domain.LoadBalancerOs;
import org.jclouds.gogrid.domain.LoadBalancerPersistenceType;
import org.jclouds.gogrid.domain.LoadBalancerState;
import org.jclouds.gogrid.domain.LoadBalancerType;
import org.jclouds.gogrid.domain.Option;

public class LoadBalancer
implements Comparable<LoadBalancer> {
    private long id;
    private String name;
    private String description;
    @SerializedName(value="virtualip")
    private IpPortPair virtualIp;
    @SerializedName(value="realiplist")
    private Set<IpPortPair> realIpList;
    private LoadBalancerType type;
    private LoadBalancerPersistenceType persistence;
    private LoadBalancerOs os;
    private LoadBalancerState state;
    private Option datacenter;

    public LoadBalancer() {
    }

    public LoadBalancer(long id, String name, String description, IpPortPair virtualIp, Set<IpPortPair> realIpList, LoadBalancerType type, LoadBalancerPersistenceType persistence, LoadBalancerOs os, LoadBalancerState state, Option datacenter) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.virtualIp = virtualIp;
        this.realIpList = realIpList;
        this.type = type;
        this.persistence = persistence;
        this.os = os;
        this.state = state;
        this.datacenter = datacenter;
    }

    public long getId() {
        return this.id;
    }

    public Option getDatacenter() {
        return this.datacenter;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public IpPortPair getVirtualIp() {
        return this.virtualIp;
    }

    public Set<IpPortPair> getRealIpList() {
        return this.realIpList;
    }

    public LoadBalancerType getType() {
        return this.type;
    }

    public LoadBalancerPersistenceType getPersistence() {
        return this.persistence;
    }

    public LoadBalancerOs getOs() {
        return this.os;
    }

    public LoadBalancerState getState() {
        return this.state;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancer other = (LoadBalancer)obj;
        if (this.datacenter == null ? other.datacenter != null : !this.datacenter.equals(other.datacenter)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.os == null ? other.os != null : !this.os.equals((Object)other.os)) {
            return false;
        }
        if (this.persistence == null ? other.persistence != null : !this.persistence.equals((Object)other.persistence)) {
            return false;
        }
        if (this.realIpList == null ? other.realIpList != null : !((Object)this.realIpList).equals(other.realIpList)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals((Object)other.state)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
            return false;
        }
        return !(this.virtualIp == null ? other.virtualIp != null : !this.virtualIp.equals(other.virtualIp));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.datacenter == null ? 0 : this.datacenter.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.os == null ? 0 : this.os.hashCode());
        result = 31 * result + (this.persistence == null ? 0 : this.persistence.hashCode());
        result = 31 * result + (this.realIpList == null ? 0 : ((Object)this.realIpList).hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.virtualIp == null ? 0 : this.virtualIp.hashCode());
        return result;
    }

    @Override
    public int compareTo(LoadBalancer o) {
        return Longs.compare(this.id, o.getId());
    }

    public String toString() {
        return "LoadBalancer [datacenter=" + this.datacenter + ", description=" + this.description + ", id=" + this.id + ", name=" + this.name + ", os=" + (Object)((Object)this.os) + ", persistence=" + (Object)((Object)this.persistence) + ", realIpList=" + this.realIpList + ", state=" + (Object)((Object)this.state) + ", type=" + (Object)((Object)this.type) + ", virtualIp=" + this.virtualIp + "]";
    }
}

