/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.functions;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.functions.GenericResponseContainer;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;

@Singleton
public class ParseServerNameToCredentialsMapFromJsonResponse
implements Function<HttpResponse, Map<String, Credentials>> {
    private final ParseJson<GenericResponseContainer<Password>> json;

    @Inject
    ParseServerNameToCredentialsMapFromJsonResponse(ParseJson<GenericResponseContainer<Password>> json) {
        this.json = json;
    }

    @Override
    public Map<String, Credentials> apply(HttpResponse arg0) {
        HashMap<String, Credentials> serverNameToCredentials = Maps.newHashMap();
        for (Password password : this.json.apply(arg0).getList()) {
            if (null == password.getServer()) continue;
            serverNameToCredentials.put(password.getServer().getName(), new Credentials(password.getUserName(), password.getPassword()));
        }
        return serverNameToCredentials;
    }

    private static class Password
    implements Comparable<Password> {
        @SerializedName(value="username")
        private String userName;
        private String password;
        private Server server;

        private Password() {
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public Server getServer() {
            return this.server;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Password password1 = (Password)o;
            if (this.password != null ? !this.password.equals(password1.password) : password1.password != null) {
                return false;
            }
            if (this.server != null ? !this.server.equals(password1.server) : password1.server != null) {
                return false;
            }
            return !(this.userName != null ? !this.userName.equals(password1.userName) : password1.userName != null);
        }

        public int hashCode() {
            int result = this.userName != null ? this.userName.hashCode() : 0;
            result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
            result = 31 * result + (this.server != null ? this.server.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(Password o) {
            if (null == o.getServer() || null == this.server) {
                return -1;
            }
            return this.server.getName().compareTo(o.getServer().getName());
        }
    }
}

