/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.lvs.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.swift.domain.ContainerMetadata;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class ParseContainerMetadataFromHeaders
implements Function<HttpResponse, ContainerMetadata>,
InvocationContext<ParseContainerMetadataFromHeaders> {
    private GeneratedHttpRequest<?> request;

    @Override
    public ContainerMetadata apply(HttpResponse from) {
        ContainerMetadata to = new ContainerMetadata();
        to.setName(this.request.getArgs().get(0).toString());
        to.setReadACL(from.getFirstHeaderOrNull("X-Container-Read"));
        to.setBytes(new Long(from.getFirstHeaderOrNull("X-Container-Bytes-Used")));
        to.setCount(new Long(from.getFirstHeaderOrNull("X-Container-Object-Count")));
        this.addUserMetadataTo(from, to);
        return to;
    }

    @VisibleForTesting
    void addUserMetadataTo(HttpResponse from, ContainerMetadata metadata) {
        for (Map.Entry<String, String> header : from.getHeaders().entries()) {
            if (header.getKey() == null || !header.getKey().startsWith("X-Container-Meta-")) continue;
            metadata.getMetadata().put(header.getKey().substring("X-Container-Meta-".length()).toLowerCase(), header.getValue());
        }
    }

    @Override
    public ParseContainerMetadataFromHeaders setContext(HttpRequest request) {
        Preconditions.checkArgument(request instanceof GeneratedHttpRequest, "note this handler requires a GeneratedHttpRequest");
        this.request = (GeneratedHttpRequest)request;
        return this;
    }
}

