/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.jclouds.http.internal.PayloadEnclosingImpl;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;

public class HttpMessage
extends PayloadEnclosingImpl {
    protected final Multimap<String, String> headers;

    public static Builder builder() {
        return new Builder();
    }

    public HttpMessage(@Nullable Payload payload, Multimap<String, String> headers) {
        super(payload);
        this.headers = ImmutableMultimap.copyOf(Preconditions.checkNotNull(headers, "headers"));
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public String getFirstHeaderOrNull(String string) {
        Collection<String> values = this.headers.get(string);
        if (values.size() == 0) {
            values = this.headers.get(string.toLowerCase());
        }
        return values.size() >= 1 ? values.iterator().next() : null;
    }

    public Builder toBuilder() {
        return Builder.from(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.headers == null ? 0 : ((Object)this.headers).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpMessage other = (HttpMessage)obj;
        return !(this.headers == null ? other.headers != null : !((Object)this.headers).equals(other.headers));
    }

    public String toString() {
        return "[headers=" + this.headers + ", payload=" + this.payload + "]";
    }

    public static class Builder {
        protected Payload payload;
        protected Multimap<String, String> headers = ImmutableMultimap.of();

        public Builder payload(Payload payload) {
            this.payload = payload;
            return this;
        }

        public Builder headers(Multimap<String, String> headers) {
            this.headers = ImmutableMultimap.copyOf(Preconditions.checkNotNull(headers, "headers"));
            return this;
        }

        public HttpMessage build() {
            return new HttpMessage(this.payload, this.headers);
        }

        public static Builder from(HttpMessage input) {
            return new Builder().payload(input.getPayload()).headers(input.getHeaders());
        }
    }
}

