/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.concurrent.Futures;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.TransformingHttpCommandExecutorService;

public class TransformingHttpCommandExecutorServiceImpl
implements TransformingHttpCommandExecutorService {
    private final HttpCommandExecutorService client;
    private final ExecutorService userThreads;

    @Inject
    public TransformingHttpCommandExecutorServiceImpl(HttpCommandExecutorService client, @Named(value="jclouds.user-threads") ExecutorService userThreads) {
        this.client = client;
        this.userThreads = userThreads;
    }

    @Override
    public <T, R extends HttpRequest> ListenableFuture<T> submit(HttpCommand command, Function<HttpResponse, T> responseTransformer) {
        return Futures.compose(this.client.submit(command), responseTransformer, this.userThreads);
    }
}

