/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.filters;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.utils.ModifyRequest;

@Singleton
public class BasicAuthentication
implements HttpRequestFilter {
    private final String header;

    @Inject
    public BasicAuthentication(@Named(value="jclouds.identity") String user, @Named(value="jclouds.credential") String password, Crypto crypto) throws UnsupportedEncodingException {
        this.header = "Basic " + CryptoStreams.base64(String.format("%s:%s", Preconditions.checkNotNull(user, "user"), Preconditions.checkNotNull(password, "password")).getBytes("UTF-8"));
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        return ModifyRequest.replaceHeader(request, "Authorization", this.header);
    }
}

