/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.InvocationContext;
import org.jclouds.util.Strings2;

public class ParseURIFromListOrLocationHeaderIf20x
implements Function<HttpResponse, URI>,
InvocationContext<ParseURIFromListOrLocationHeaderIf20x> {
    private final Provider<UriBuilder> uriBuilderProvider;
    private HttpRequest request;

    @Inject
    ParseURIFromListOrLocationHeaderIf20x(Provider<UriBuilder> uriBuilderProvider) {
        this.uriBuilderProvider = uriBuilderProvider;
    }

    @Override
    public URI apply(HttpResponse from) {
        if (from.getStatusCode() > 206) {
            throw new HttpException(String.format("Unhandled status code  - %1$s", from));
        }
        if ("text/uri-list".equals(from.getFirstHeaderOrNull("Content-Type"))) {
            try {
                if (from.getPayload().getInput() == null) {
                    throw new HttpResponseException("no content", null, from);
                }
                String toParse = Strings2.toStringAndClose(from.getPayload().getInput());
                URI uRI = URI.create(toParse.trim());
                return uRI;
            }
            catch (IOException e) {
                throw new HttpResponseException("couldn't parse uri from content", null, from, (Throwable)e);
            }
            finally {
                HttpUtils.releasePayload(from);
            }
        }
        HttpUtils.releasePayload(from);
        String location = from.getFirstHeaderOrNull("Location");
        if (location == null) {
            location = from.getFirstHeaderOrNull("location");
        }
        if (location != null) {
            URI locationUri = URI.create(location);
            if (locationUri.getHost() != null) {
                return locationUri;
            }
            Preconditions.checkState(this.request != null, "request should have been initialized");
            if (!location.startsWith("/")) {
                location = "/" + location;
            }
            UriBuilder builder = this.uriBuilderProvider.get().uri(URI.create("http://localhost" + location));
            builder.host(this.request.getEndpoint().getHost());
            builder.port(this.request.getEndpoint().getPort());
            builder.scheme(this.request.getEndpoint().getScheme());
            return builder.build(new Object[0]);
        }
        throw new HttpResponseException("no uri in headers or content", null, from);
    }

    @Override
    public ParseURIFromListOrLocationHeaderIf20x setContext(HttpRequest request) {
        this.request = request;
        return this;
    }
}

