/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.handlers;

import com.google.inject.Inject;
import java.net.URI;
import java.util.Collections;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.logging.Logger;

@Singleton
public class RedirectionRetryHandler
implements HttpRetryHandler {
    @Inject(optional=true)
    @Named(value="jclouds.max-redirects")
    protected int retryCountLimit = 5;
    @Resource
    protected Logger logger = Logger.NULL;
    protected final BackoffLimitedRetryHandler backoffHandler;
    protected final Provider<UriBuilder> uriBuilderProvider;

    @Inject
    protected RedirectionRetryHandler(Provider<UriBuilder> uriBuilderProvider, BackoffLimitedRetryHandler backoffHandler) {
        this.backoffHandler = backoffHandler;
        this.uriBuilderProvider = uriBuilderProvider;
    }

    @Override
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        HttpUtils.closeClientButKeepContentStream(response);
        String hostHeader = response.getFirstHeaderOrNull("Location");
        if (command.incrementRedirectCount() < this.retryCountLimit && hostHeader != null) {
            HttpRequest currentRequest;
            URI redirectionUrl = URI.create(hostHeader);
            if (redirectionUrl.equals((currentRequest = command.getCurrentRequest()).getEndpoint())) {
                return this.backoffHandler.shouldRetryRequest(command, response);
            }
            assert (redirectionUrl.getPath() != null) : "no path in redirect header from: " + response;
            if (!redirectionUrl.isAbsolute()) {
                UriBuilder builder = this.uriBuilderProvider.get().uri(currentRequest.getEndpoint());
                builder.replacePath(redirectionUrl.getPath());
                if (redirectionUrl.getQuery() != null) {
                    builder.replaceQuery(redirectionUrl.getQuery());
                }
                redirectionUrl = builder.build(new Object[0]);
            }
            if (currentRequest.getFirstHeaderOrNull("Host") != null && redirectionUrl.getHost() != null) {
                command.setCurrentRequest(ModifyRequest.replaceHeader(currentRequest, "Host", Collections.singletonList(redirectionUrl.getHost())).toBuilder().endpoint(redirectionUrl).build());
            } else {
                command.setCurrentRequest(currentRequest.toBuilder().endpoint(redirectionUrl).build());
            }
            return true;
        }
        return false;
    }
}

