/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.CountingOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.jclouds.JcloudsVersion;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.BaseHttpCommandExecutorService;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.logging.Logger;
import org.jclouds.rest.internal.RestAnnotationProcessor;

@Singleton
public class JavaUrlHttpCommandExecutorService
extends BaseHttpCommandExecutorService<HttpURLConnection> {
    public static final String USER_AGENT = String.format("jclouds/%s java/%s", JcloudsVersion.get(), System.getProperty("java.version"));
    @Resource
    protected Logger logger = Logger.NULL;
    private final Supplier<SSLContext> untrustedSSLContextProvider;
    private final HostnameVerifier verifier;
    private final Field methodField;

    @Inject
    public JavaUrlHttpCommandExecutorService(HttpUtils utils, @Named(value="jclouds.io-worker-threads") ExecutorService ioWorkerExecutor, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, @Named(value="untrusted") HostnameVerifier verifier, @Named(value="untrusted") Supplier<SSLContext> untrustedSSLContextProvider) throws SecurityException, NoSuchFieldException {
        super(utils, ioWorkerExecutor, retryHandler, ioRetryHandler, errorHandler, wire);
        if (utils.getMaxConnections() > 0) {
            System.setProperty("http.maxConnections", String.valueOf(Preconditions.checkNotNull(utils, "utils").getMaxConnections()));
        }
        this.untrustedSSLContextProvider = Preconditions.checkNotNull(untrustedSSLContextProvider, "untrustedSSLContextProvider");
        this.verifier = Preconditions.checkNotNull(verifier, "verifier");
        this.methodField = HttpURLConnection.class.getDeclaredField("method");
        this.methodField.setAccessible(true);
    }

    @Override
    protected HttpResponse invoke(HttpURLConnection connection) throws IOException, InterruptedException {
        InputStreamPayload payload;
        InputStream in;
        HttpResponse.Builder builder;
        block6: {
            builder = HttpResponse.builder();
            in = null;
            try {
                in = JavaUrlHttpCommandExecutorService.consumeOnClose(connection.getInputStream());
            }
            catch (IOException e) {
                in = this.bufferAndCloseStream(connection.getErrorStream());
            }
            catch (RuntimeException e) {
                Closeables.closeQuietly(in);
                Throwables.propagate(e);
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)"should have propagated exception");
            }
        }
        int responseCode = connection.getResponseCode();
        if (responseCode == 204) {
            Closeables.closeQuietly(in);
            in = null;
        }
        builder.statusCode(responseCode);
        builder.message(connection.getResponseMessage());
        ImmutableMultimap.Builder headerBuilder = ImmutableMultimap.builder();
        for (String header : connection.getHeaderFields().keySet()) {
            if (header == null) continue;
            headerBuilder.putAll(header, (Iterable)connection.getHeaderFields().get(header));
        }
        ImmutableMultimap<String, String> headers = headerBuilder.build();
        InputStreamPayload inputStreamPayload = payload = in != null ? Payloads.newInputStreamPayload(in) : null;
        if (payload != null) {
            payload.getContentMetadata().setPropertiesFromHttpHeaders(headers);
            builder.payload(payload);
        }
        builder.headers((Multimap)RestAnnotationProcessor.filterOutContentHeaders(headers));
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream bufferAndCloseStream(InputStream inputStream) throws IOException {
        ByteArrayInputStream in = null;
        try {
            if (inputStream != null) {
                in = new ByteArrayInputStream(ByteStreams.toByteArray(inputStream));
            }
        }
        finally {
            Closeables.closeQuietly(inputStream);
        }
        return in;
    }

    @Override
    protected HttpURLConnection convert(HttpRequest request) throws IOException, InterruptedException {
        HttpURLConnection connection;
        Proxy proxy;
        boolean chunked = "chunked".equals(request.getFirstHeaderOrNull("Transfer-Encoding"));
        URL url = request.getEndpoint().toURL();
        if (this.utils.useSystemProxies()) {
            System.setProperty("java.net.useSystemProxies", "true");
            List<Proxy> proxies = ProxySelector.getDefault().select(request.getEndpoint());
            proxy = Iterables.getLast(proxies);
            connection = (HttpURLConnection)url.openConnection(proxy);
        } else if (this.utils.getProxyHost() != null) {
            InetSocketAddress addr = new InetSocketAddress(this.utils.getProxyHost(), (int)this.utils.getProxyPort());
            proxy = new Proxy(Proxy.Type.HTTP, addr);
            Authenticator authenticator = new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(JavaUrlHttpCommandExecutorService.this.utils.getProxyUser(), JavaUrlHttpCommandExecutorService.this.utils.getProxyPassword().toCharArray());
                }
            };
            Authenticator.setDefault(authenticator);
            connection = (HttpURLConnection)url.openConnection(proxy);
        } else {
            connection = (HttpURLConnection)url.openConnection();
        }
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection sslCon = (HttpsURLConnection)connection;
            if (this.utils.relaxHostname()) {
                sslCon.setHostnameVerifier(this.verifier);
            }
            if (this.utils.trustAllCerts()) {
                sslCon.setSSLSocketFactory(this.untrustedSSLContextProvider.get().getSocketFactory());
            }
        }
        if (this.utils.getConnectionTimeout() > 0) {
            connection.setConnectTimeout(this.utils.getConnectionTimeout());
        }
        if (this.utils.getSocketOpenTimeout() > 0) {
            connection.setReadTimeout(this.utils.getSocketOpenTimeout());
        }
        connection.setDoOutput(true);
        connection.setAllowUserInteraction(false);
        connection.setInstanceFollowRedirects(false);
        try {
            connection.setRequestMethod(request.getMethod());
        }
        catch (ProtocolException e) {
            try {
                this.methodField.set(connection, request.getMethod());
            }
            catch (Exception e1) {
                this.logger.error(e, "could not set request method: ", request.getMethod());
                Throwables.propagate(e1);
            }
        }
        for (String header : request.getHeaders().keys()) {
            for (String value : request.getHeaders().get(header)) {
                connection.setRequestProperty(header, value);
            }
        }
        connection.setRequestProperty("Host", request.getEndpoint().getHost());
        connection.setRequestProperty("User-Agent", USER_AGENT);
        if (request.getPayload() != null) {
            MutableContentMetadata md = request.getPayload().getContentMetadata();
            if (md.getContentMD5() != null) {
                connection.setRequestProperty("Content-MD5", CryptoStreams.base64(md.getContentMD5()));
            }
            if (md.getContentType() != null) {
                connection.setRequestProperty("Content-Type", md.getContentType());
            }
            if (md.getContentDisposition() != null) {
                connection.setRequestProperty("Content-Disposition", md.getContentDisposition());
            }
            if (md.getContentEncoding() != null) {
                connection.setRequestProperty("Content-Encoding", md.getContentEncoding());
            }
            if (md.getContentLanguage() != null) {
                connection.setRequestProperty("Content-Language", md.getContentLanguage());
            }
            if (chunked) {
                connection.setChunkedStreamingMode(8196);
            } else {
                Long length = Preconditions.checkNotNull(md.getContentLength(), "payload.getContentLength");
                connection.setRequestProperty("Content-Length", length.toString());
                Preconditions.checkArgument(length < Integer.MAX_VALUE, "JDK 1.6 does not support >2GB chunks. Use chunked encoding, if possible.");
                connection.setFixedLengthStreamingMode(length.intValue());
                if (length.intValue() > 0) {
                    connection.setRequestProperty("Expect", "100-continue");
                }
            }
            CountingOutputStream out = new CountingOutputStream(connection.getOutputStream());
            try {
                request.getPayload().writeTo(out);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("error after writing %d/%s bytes to %s", out.getCount(), md.getContentLength(), request.getRequestLine()), e);
            }
        } else {
            connection.setRequestProperty("Content-Length", "0");
            if (connection.getRequestMethod().equals("POST") || connection.getRequestMethod().equals("PUT")) {
                connection.setFixedLengthStreamingMode(0);
            }
        }
        return connection;
    }

    @Override
    protected void cleanup(HttpURLConnection connection) {
        if (connection != null && connection.getContentLength() == 0) {
            connection.disconnect();
        }
    }
}

