/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payloads;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.Strings2;

public class ModifyRequest {
    public static <R extends HttpRequest> R putHeaders(R request, Multimap<String, String> moreHeaders) {
        return (R)((HttpRequest.Builder)request.toBuilder().headers(ImmutableMultimap.builder().putAll(request.getHeaders()).putAll(moreHeaders).build())).build();
    }

    public static <R extends HttpRequest> R endpoint(R request, URI endpoint) {
        return (R)Preconditions.checkNotNull(request, "request").toBuilder().endpoint(Preconditions.checkNotNull(endpoint, "endpoint")).build();
    }

    public static <R extends HttpRequest> R replaceHeaders(R request, Multimap<String, String> headers) {
        LinkedHashMultimap<String, String> newHeaders = LinkedHashMultimap.create(Preconditions.checkNotNull(request, "request").getHeaders());
        for (String header : headers.keySet()) {
            newHeaders.replaceValues(header, headers.get(header));
        }
        return (R)((HttpRequest.Builder)request.toBuilder().headers(newHeaders)).build();
    }

    public static <R extends HttpRequest> R replaceHeader(R request, String header, String ... values) {
        return ModifyRequest.replaceHeader(request, header, ImmutableList.copyOf((Object[])Preconditions.checkNotNull(values, "values")));
    }

    public static <R extends HttpRequest> R replaceHeader(R request, String header, Iterable<String> values) {
        LinkedHashMultimap<String, String> headers = LinkedHashMultimap.create(Preconditions.checkNotNull(request, "request").getHeaders());
        headers.replaceValues(Preconditions.checkNotNull(header, "header"), Preconditions.checkNotNull(values, "values"));
        return (R)((HttpRequest.Builder)request.toBuilder().headers(headers)).build();
    }

    public static <R extends HttpRequest> R removeHeader(R request, String header) {
        LinkedHashMultimap<String, String> headers = LinkedHashMultimap.create(Preconditions.checkNotNull(request, "request").getHeaders());
        headers.removeAll(Preconditions.checkNotNull(header, "header"));
        return (R)((HttpRequest.Builder)request.toBuilder().headers(headers)).build();
    }

    public static <R extends HttpRequest> R addQueryParam(R request, String key, Object value, UriBuilder builder) {
        return ModifyRequest.addQueryParam(request, key, ImmutableSet.of(value), builder, request.getSkips());
    }

    public static <R extends HttpRequest> R addQueryParam(R request, String key, Iterable<?> values, UriBuilder builder) {
        return ModifyRequest.addQueryParam(request, key, values, builder, request.getSkips());
    }

    public static <R extends HttpRequest> R addQueryParam(R request, String key, Iterable<?> values, UriBuilder builder, char ... skips) {
        builder.uri(request.getEndpoint());
        Multimap<String, String> map = ModifyRequest.parseQueryToMap(request.getEndpoint().getQuery());
        for (Object o : values) {
            map.put(key, o.toString());
        }
        builder.replaceQuery(ModifyRequest.makeQueryLine(map, null, skips));
        return (R)request.toBuilder().endpoint(builder.build(new Object[0])).build();
    }

    public static <R extends HttpRequest> R addQueryParams(R request, Multimap<String, String> parameters, UriBuilder builder) {
        return ModifyRequest.addQueryParams(request, parameters, builder, request.getSkips());
    }

    public static <R extends HttpRequest> R addQueryParams(R request, Multimap<String, String> parameters, UriBuilder builder, char ... skips) {
        builder.uri(request.getEndpoint());
        Multimap<String, String> map = ModifyRequest.parseQueryToMap(request.getEndpoint().getQuery());
        map.putAll(parameters);
        builder.replaceQuery(ModifyRequest.makeQueryLine(map, null, skips));
        return (R)request.toBuilder().endpoint(builder.build(new Object[0])).build();
    }

    public static <R extends HttpRequest> R replaceMatrixParam(R request, String name, Object value, UriBuilder builder) {
        return ModifyRequest.replaceMatrixParam(request, name, new Object[]{value}, builder);
    }

    public static <R extends HttpRequest> R replaceMatrixParam(R request, String name, Object[] values, UriBuilder builder) {
        builder.uri(request.getEndpoint());
        builder.replaceMatrixParam(name, values);
        return (R)request.toBuilder().endpoint(builder.build(new Object[0])).build();
    }

    public static <R extends HttpRequest> R addFormParam(R request, String key, String value) {
        return ModifyRequest.addFormParam(request, key, ImmutableSet.of(value));
    }

    public static <R extends HttpRequest> R addFormParam(R request, String key, Iterable<?> values) {
        LinkedHashMultimap<String, String> map = request.getPayload() != null ? ModifyRequest.parseQueryToMap(request.getPayload().getRawContent().toString()) : LinkedHashMultimap.create();
        for (Object o : values) {
            map.put(key, o.toString());
        }
        return (R)request.toBuilder().payload(Payloads.newUrlEncodedFormPayload(map, new char[0])).build();
    }

    public static <R extends HttpRequest> R putFormParams(R request, Multimap<String, String> params) {
        LinkedHashMultimap<String, String> map = request.getPayload() != null ? ModifyRequest.parseQueryToMap(request.getPayload().getRawContent().toString()) : LinkedHashMultimap.create();
        map.putAll(params);
        return (R)request.toBuilder().payload(Payloads.newUrlEncodedFormPayload(map, new char[0])).build();
    }

    public static Multimap<String, String> parseQueryToMap(String in) {
        LinkedListMultimap<String, String> map = LinkedListMultimap.create();
        if (in != null) {
            if (in.indexOf(38) == -1) {
                if (in.contains("=")) {
                    ModifyRequest.parseKeyValueFromStringToMap(in, map);
                } else {
                    map.put(in, null);
                }
            } else {
                String[] parts;
                for (String part : parts = Strings2.urlDecode(in).split("&")) {
                    ModifyRequest.parseKeyValueFromStringToMap(part, map);
                }
            }
        }
        return map;
    }

    public static void parseKeyValueFromStringToMap(String stringToParse, Multimap<String, String> map) {
        int indexOfFirstEquals = stringToParse.indexOf(61);
        String key = indexOfFirstEquals == -1 ? stringToParse : stringToParse.substring(0, indexOfFirstEquals);
        String value = indexOfFirstEquals == -1 ? null : stringToParse.substring(indexOfFirstEquals + 1);
        map.put(key, value);
    }

    public static String makeQueryLine(Multimap<String, String> params, @Nullable Comparator<Map.Entry<String, String>> sorter, char ... skips) {
        Iterator<Map.Entry<String, String>> pairs = (sorter == null ? params.entries() : ImmutableSortedSet.copyOf(sorter, params.entries())).iterator();
        StringBuilder formBuilder = new StringBuilder();
        while (pairs.hasNext()) {
            Map.Entry<String, String> pair = pairs.next();
            formBuilder.append(Strings2.urlEncode(pair.getKey(), skips));
            if (pair.getValue() != null) {
                formBuilder.append("=");
            }
            if (pair.getValue() != null && !pair.getValue().equals("")) {
                formBuilder.append(Strings2.urlEncode(pair.getValue(), skips));
            }
            if (!pairs.hasNext()) continue;
            formBuilder.append("&");
        }
        return formBuilder.toString();
    }
}

