/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.internal;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jclouds.javax.annotation.Nullable;

public class ClassMethodArgs {
    private final Method method;
    private final Object[] args;
    private final Class<?> asyncClass;

    public ClassMethodArgs(Class<?> asyncClass, Method method, @Nullable Object[] args) {
        this.asyncClass = Preconditions.checkNotNull(asyncClass, "asyncClass");
        this.method = Preconditions.checkNotNull(method, "method");
        this.args = args;
    }

    public String toString() {
        return "[class=" + this.asyncClass.getSimpleName() + ", method=" + this.method.getName() + ", args=" + Arrays.toString(this.args) + "]";
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + (this.asyncClass == null ? 0 : this.asyncClass.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassMethodArgs other = (ClassMethodArgs)obj;
        if (!Arrays.equals(this.args, other.args)) {
            return false;
        }
        if (this.asyncClass == null ? other.asyncClass != null : !this.asyncClass.equals(other.asyncClass)) {
            return false;
        }
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    public Class<?> getAsyncClass() {
        return this.asyncClass;
    }
}

