/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.payloads;

import java.io.Serializable;
import java.util.Arrays;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataBuilder;

public class BaseImmutableContentMetadata
implements ContentMetadata,
Serializable {
    private static final long serialVersionUID = -1445533440795766130L;
    protected String contentType;
    protected Long contentLength;
    protected byte[] contentMD5;
    protected String contentDisposition;
    protected String contentLanguage;
    protected String contentEncoding;

    public BaseImmutableContentMetadata(String contentType, Long contentLength, byte[] contentMD5, String contentDisposition, String contentLanguage, String contentEncoding) {
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.contentMD5 = contentMD5;
        this.contentDisposition = contentDisposition;
        this.contentLanguage = contentLanguage;
        this.contentEncoding = contentEncoding;
    }

    @Override
    public Long getContentLength() {
        return this.contentLength;
    }

    @Override
    public byte[] getContentMD5() {
        if (this.contentMD5 != null) {
            byte[] retval = new byte[this.contentMD5.length];
            System.arraycopy(this.contentMD5, 0, retval, 0, this.contentMD5.length);
            return retval;
        }
        return null;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getContentDisposition() {
        return this.contentDisposition;
    }

    @Override
    public String getContentLanguage() {
        return this.contentLanguage;
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String toString() {
        return "[contentType=" + this.contentType + ", contentLength=" + this.contentLength + ", contentDisposition=" + this.contentDisposition + ", contentEncoding=" + this.contentEncoding + ", contentLanguage=" + this.contentLanguage + ", contentMD5=" + Arrays.toString(this.contentMD5) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contentDisposition == null ? 0 : this.contentDisposition.hashCode());
        result = 31 * result + (this.contentEncoding == null ? 0 : this.contentEncoding.hashCode());
        result = 31 * result + (this.contentLanguage == null ? 0 : this.contentLanguage.hashCode());
        result = 31 * result + (this.contentLength == null ? 0 : this.contentLength.hashCode());
        result = 31 * result + Arrays.hashCode(this.contentMD5);
        result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseImmutableContentMetadata other = (BaseImmutableContentMetadata)obj;
        if (this.contentDisposition == null ? other.contentDisposition != null : !this.contentDisposition.equals(other.contentDisposition)) {
            return false;
        }
        if (this.contentEncoding == null ? other.contentEncoding != null : !this.contentEncoding.equals(other.contentEncoding)) {
            return false;
        }
        if (this.contentLanguage == null ? other.contentLanguage != null : !this.contentLanguage.equals(other.contentLanguage)) {
            return false;
        }
        if (this.contentLength == null ? other.contentLength != null : !this.contentLength.equals(other.contentLength)) {
            return false;
        }
        if (!Arrays.equals(this.contentMD5, other.contentMD5)) {
            return false;
        }
        return !(this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType));
    }

    @Override
    public ContentMetadataBuilder toBuilder() {
        return ContentMetadataBuilder.fromContentMetadata(this);
    }
}

