/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.payloads;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.jclouds.io.payloads.BasePayload;

public class FilePayload
extends BasePayload<File> {
    public FilePayload(File content) {
        super(content);
        this.getContentMetadata().setContentLength(content.length());
        Preconditions.checkArgument(Preconditions.checkNotNull(content, "content").exists(), "file must exist: " + content);
    }

    @Override
    public InputStream getInput() {
        try {
            return new FileInputStream((File)this.content);
        }
        catch (FileNotFoundException e) {
            Throwables.propagate(e);
            return null;
        }
    }
}

