/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutionException;

public class EnumTypeAdapterThatReturnsFromValue<T extends Enum<T>>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    private static final LoadingCache<Class<?>, Method> classToConvert = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Method>(){

        @Override
        public Method load(Class<?> from) throws ExecutionException {
            try {
                Method method = from.getMethod("fromValue", String.class);
                method.setAccessible(true);
                return method;
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
    });

    @Override
    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(((Enum)src).name());
    }

    @Override
    public T deserialize(JsonElement json, Type classOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            return Enum.valueOf((Class)classOfT, json.getAsString());
        }
        catch (IllegalArgumentException e) {
            try {
                Method converter = classToConvert.get((Class)classOfT);
                return (T)((Enum)converter.invoke(null, json.getAsString()));
            }
            catch (Exception e1) {
                throw e;
            }
        }
    }

    public String toString() {
        return EnumTypeAdapterThatReturnsFromValue.class.getSimpleName();
    }
}

