/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.services.modules;

import java.io.IOException;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jclouds.domain.Credentials;
import org.jclouds.karaf.core.CredentialStore;
import org.jclouds.rest.ConfiguresCredentialStore;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfiguresCredentialStore
public class ConfigurationAdminCredentialStore
extends CredentialStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationAdminCredentialStore.class);
    public static final String CREDENTIAL_STORE_PID = "org.jclouds.credentials";
    private ConfigurationAdmin configurationAdmin;
    private Configuration configuration;

    public void init() throws IOException {
        this.configuration = this.configurationAdmin.getConfiguration(CREDENTIAL_STORE_PID);
        this.store = new ConfigurationAdminBacking(this.configuration);
    }

    @Override
    protected void configure() {
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    private class ConfigurationAdminBacking
    implements Map<String, Credentials> {
        private final Configuration configuration;
        private final Map<String, Credentials> credentialsMap = new LinkedHashMap<String, Credentials>();

        private ConfigurationAdminBacking(Configuration configuration) {
            this.configuration = configuration;
            try {
                Dictionary dictionary = configuration.getProperties();
                if (dictionary == null) {
                    dictionary = this.newDisctionary();
                }
                Enumeration keys = dictionary.keys();
                while (keys.hasMoreElements()) {
                    String stripedKey;
                    String key = (String)keys.nextElement();
                    if (key == null || !key.startsWith("node#") || this.credentialsMap.containsKey(stripedKey = key.substring(0, key.lastIndexOf("/")))) continue;
                    String identityKey = stripedKey + "/identity";
                    String credentialKey = stripedKey + "/credential";
                    String identity = (String)dictionary.get(identityKey);
                    String credential = (String)dictionary.get(credentialKey);
                    Credentials credentials = new Credentials(identity, credential);
                    this.credentialsMap.put(stripedKey, credentials);
                }
                configuration.update(dictionary);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to store jclouds credentials to configuration admin.", (Throwable)e);
            }
        }

        public Dictionary newDisctionary() {
            Properties dictionary = new Properties();
            return dictionary;
        }

        @Override
        public int size() {
            return this.credentialsMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.credentialsMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object o) {
            return this.credentialsMap.containsKey(o);
        }

        @Override
        public boolean containsValue(Object o) {
            return this.credentialsMap.containsValue(o);
        }

        @Override
        public Credentials get(Object o) {
            return this.credentialsMap.get(o);
        }

        @Override
        public Credentials put(String s, Credentials credentials) {
            try {
                Dictionary dictionary = this.configuration.getProperties();
                if (dictionary == null) {
                    // empty if block
                }
                String identityKey = s + "/identity";
                String credentialKey = s + "/credential";
                dictionary.put(identityKey, credentials.identity);
                dictionary.put(credentialKey, credentials.credential);
                this.configuration.update(dictionary);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to store jclouds credentials to configuration admin.", (Throwable)e);
            }
            return this.credentialsMap.put(s, credentials);
        }

        @Override
        public Credentials remove(Object o) {
            try {
                Dictionary dictionary = this.configuration.getProperties();
                if (dictionary == null) {
                    dictionary = this.newDisctionary();
                }
                String identityKey = o + "/identity";
                dictionary.remove(identityKey);
                this.configuration.update(dictionary);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to store jclouds credentials to configuration admin.", (Throwable)e);
            }
            return this.credentialsMap.remove(o);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Credentials> map) {
            for (Map.Entry<? extends String, ? extends Credentials> entry : map.entrySet()) {
                String s = entry.getKey();
                Credentials credential = entry.getValue();
                this.put(s, credential);
            }
        }

        @Override
        public void clear() {
            try {
                this.configuration.update(this.newDisctionary());
            }
            catch (IOException e) {
                LOGGER.warn("Failed to clear configuration admin jclouds credentials store.", (Throwable)e);
            }
            this.credentialsMap.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.credentialsMap.keySet();
        }

        @Override
        public Collection<Credentials> values() {
            return this.credentialsMap.values();
        }

        @Override
        public Set<Map.Entry<String, Credentials>> entrySet() {
            return this.credentialsMap.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.credentialsMap).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.credentialsMap).hashCode();
        }
    }
}

