/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.loadbalancer.config;

import com.google.common.base.Supplier;
import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.domain.Location;
import org.jclouds.location.suppliers.OnlyLocationOrFirstRegionOptionallyMatchingRegionId;

public abstract class BindLoadBalancerSuppliersByClass
extends AbstractModule {
    @Override
    protected void configure() {
        this.bindLocationSupplier(this.defineLocationSupplier());
        this.bindDefaultLocationSupplier(this.defineDefaultLocationSupplier());
    }

    protected Class<? extends Supplier<Set<? extends Location>>> defineLocationSupplier() {
        return SupplierOfLocationSet.class;
    }

    protected Class<? extends Supplier<Location>> defineDefaultLocationSupplier() {
        return OnlyLocationOrFirstRegionOptionallyMatchingRegionId.class;
    }

    protected void bindImageSupplier(Class<? extends Supplier<Set<? extends Image>>> clazz) {
        this.bind(new TypeLiteral<Supplier<Set<? extends Image>>>(){}).to(clazz).in(Scopes.SINGLETON);
    }

    protected void bindLocationSupplier(Class<? extends Supplier<Set<? extends Location>>> clazz) {
        this.bind(new TypeLiteral<Supplier<Set<? extends Location>>>(){}).to(clazz).in(Scopes.SINGLETON);
    }

    protected void bindDefaultLocationSupplier(Class<? extends Supplier<Location>> clazz) {
        this.bind(new TypeLiteral<Supplier<Location>>(){}).to(clazz).in(Scopes.SINGLETON);
    }

    protected void bindHardwareSupplier(Class<? extends Supplier<Set<? extends Hardware>>> clazz) {
        this.bind(new TypeLiteral<Supplier<Set<? extends Hardware>>>(){}).to(clazz).in(Scopes.SINGLETON);
    }

    @Singleton
    static class SupplierOfLocationSet
    implements Supplier<Set<? extends Location>> {
        private final Set<? extends Location> locations;

        @Inject
        SupplierOfLocationSet(Set<? extends Location> locations) {
            this.locations = locations;
        }

        @Override
        public Set<? extends Location> get() {
            return this.locations;
        }
    }
}

